/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import java.nio.ByteOrder;
import java.util.function.Consumer;
import org.eclipse.serializer.persistence.types.ByteOrderTargeting;
import org.eclipse.serializer.persistence.types.PersistenceContextDispatcher;
import org.eclipse.serializer.persistence.types.PersistenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceLocalObjectIdRegistry;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdRequestor;
import org.eclipse.serializer.persistence.types.PersistenceObjectManager;
import org.eclipse.serializer.persistence.types.PersistenceObjectRegistry;
import org.eclipse.serializer.persistence.types.PersistenceRegisterer;
import org.eclipse.serializer.persistence.types.PersistenceRetrieving;
import org.eclipse.serializer.persistence.types.PersistenceSource;
import org.eclipse.serializer.persistence.types.PersistenceSourceSupplier;
import org.eclipse.serializer.persistence.types.PersistenceStorer;
import org.eclipse.serializer.persistence.types.PersistenceTarget;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionary;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandlerManager;
import org.eclipse.serializer.persistence.types.Persister;
import org.eclipse.serializer.persistence.types.Unpersistable;
import org.eclipse.serializer.util.BufferSizeProviderIncremental;
import org.eclipse.serializer.util.X;

public interface PersistenceManager<D>
extends PersistenceObjectManager<D>,
PersistenceRetrieving,
Persister,
PersistenceSourceSupplier<D>,
ByteOrderTargeting<PersistenceManager<D>> {
    @Override
    public PersistenceStorer createLazyStorer();

    @Override
    public PersistenceStorer createStorer();

    @Override
    public PersistenceStorer createEagerStorer();

    public PersistenceStorer createStorer(PersistenceStorer.Creator<D> var1);

    public PersistenceLoader createLoader();

    public PersistenceRegisterer createRegisterer();

    public void updateMetadata(PersistenceTypeDictionary var1, long var2, long var4);

    default public void updateMetadata(PersistenceTypeDictionary typeDictionary) {
        this.updateMetadata(typeDictionary, 0L, 0L);
    }

    public PersistenceObjectRegistry objectRegistry();

    public PersistenceTypeDictionary typeDictionary();

    @Override
    public long currentObjectId();

    @Override
    public PersistenceManager<D> updateCurrentObjectId(long var1);

    @Override
    public PersistenceSource<D> source();

    public PersistenceTarget<D> target();

    public void close();

    public static <D> PersistenceManager<D> New(PersistenceObjectRegistry objectRegistering, PersistenceObjectManager<D> objectManager, PersistenceTypeHandlerManager<D> typeHandlerManager, PersistenceContextDispatcher<D> contextDispatcher, PersistenceStorer.Creator<D> storerCreator, PersistenceLoader.Creator<D> loaderCreator, PersistenceRegisterer.Creator registererCreator, Persister persister, PersistenceTarget<D> target, PersistenceSource<D> source, PersistenceStorer.CreationObserver storerObserver, BufferSizeProviderIncremental bufferSizeProvider, ByteOrder targetByteOrder) {
        return new Default((PersistenceObjectRegistry)X.notNull((Object)objectRegistering), (PersistenceObjectManager)X.notNull(objectManager), (PersistenceTypeHandlerManager)X.notNull(typeHandlerManager), (PersistenceContextDispatcher)X.notNull(contextDispatcher), (PersistenceStorer.Creator)X.notNull(storerCreator), (PersistenceLoader.Creator)X.notNull(loaderCreator), (PersistenceRegisterer.Creator)X.notNull((Object)registererCreator), (Persister)X.mayNull((Object)persister), (PersistenceTarget)X.notNull(target), (PersistenceSource)X.notNull(source), (PersistenceStorer.CreationObserver)X.notNull((Object)storerObserver), (BufferSizeProviderIncremental)X.notNull((Object)bufferSizeProvider), (ByteOrder)X.notNull((Object)targetByteOrder));
    }

    public static final class Default<D>
    implements PersistenceManager<D>,
    Unpersistable {
        private final PersistenceObjectRegistry objectRegistry;
        private final PersistenceObjectManager<D> objectManager;
        private final PersistenceRegisterer.Creator registererCreator;
        private final PersistenceTypeHandlerManager<D> typeHandlerManager;
        private final PersistenceContextDispatcher<D> contextDispatcher;
        private final PersistenceStorer.Creator<D> storerCreator;
        private final PersistenceLoader.Creator<D> loaderCreator;
        private final PersistenceStorer.CreationObserver storerObserver;
        private final BufferSizeProviderIncremental bufferSizeProvider;
        private final Persister persister;
        private final PersistenceSource<D> source;
        private final PersistenceTarget<D> target;
        private final ByteOrder targetByteOrder;
        private final Object storeMutex = new Object();

        Default(PersistenceObjectRegistry objectRegistering, PersistenceObjectManager<D> objectManager, PersistenceTypeHandlerManager<D> typeHandlerManager, PersistenceContextDispatcher<D> contextDispatcher, PersistenceStorer.Creator<D> storerCreator, PersistenceLoader.Creator<D> loaderCreator, PersistenceRegisterer.Creator registererCreator, Persister persister, PersistenceTarget<D> target, PersistenceSource<D> source, PersistenceStorer.CreationObserver storerObserver, BufferSizeProviderIncremental bufferSizeProvider, ByteOrder targetByteOrder) {
            this.objectRegistry = objectRegistering;
            this.objectManager = objectManager;
            this.typeHandlerManager = typeHandlerManager;
            this.contextDispatcher = contextDispatcher;
            this.storerCreator = storerCreator;
            this.loaderCreator = loaderCreator;
            this.registererCreator = registererCreator;
            this.persister = persister;
            this.target = target;
            this.source = source;
            this.storerObserver = storerObserver;
            this.bufferSizeProvider = bufferSizeProvider;
            this.targetByteOrder = targetByteOrder;
        }

        @Override
        public final ByteOrder getTargetByteOrder() {
            return this.targetByteOrder;
        }

        @Override
        public final PersistenceObjectRegistry objectRegistry() {
            return this.objectRegistry;
        }

        @Override
        public final PersistenceTypeDictionary typeDictionary() {
            return this.typeHandlerManager.typeDictionary();
        }

        @Override
        public final void consolidate() {
            this.objectRegistry.consolidate();
        }

        private final Persister getEffectivePersister() {
            return (Persister)X.coalesce((Object)this.persister, (Object)this);
        }

        private <S extends PersistenceStorer> S registerStorer(S storer) {
            this.storerObserver.observeCreatedStorer(storer);
            return storer;
        }

        @Override
        public final PersistenceStorer createLazyStorer() {
            return this.registerStorer(this.storerCreator.createLazyStorer(this.contextDispatcher.dispatchTypeHandlerManager(this.typeHandlerManager), this.contextDispatcher.dispatchObjectManager(this.objectManager), this.getEffectivePersister(), this.target, this.bufferSizeProvider));
        }

        @Override
        public final PersistenceStorer createStorer() {
            return this.registerStorer(this.storerCreator.createStorer(this.contextDispatcher.dispatchTypeHandlerManager(this.typeHandlerManager), this.contextDispatcher.dispatchObjectManager(this.objectManager), this.getEffectivePersister(), this.target, this.bufferSizeProvider));
        }

        @Override
        public final PersistenceStorer createEagerStorer() {
            return this.registerStorer(this.storerCreator.createEagerStorer(this.contextDispatcher.dispatchTypeHandlerManager(this.typeHandlerManager), this.contextDispatcher.dispatchObjectManager(this.objectManager), this.getEffectivePersister(), this.target, this.bufferSizeProvider));
        }

        @Override
        public final PersistenceStorer createStorer(PersistenceStorer.Creator<D> storerCreator) {
            return this.registerStorer(storerCreator.createStorer(this.contextDispatcher.dispatchTypeHandlerManager(this.typeHandlerManager), this.contextDispatcher.dispatchObjectManager(this.objectManager), this.getEffectivePersister(), this.target, this.bufferSizeProvider));
        }

        @Override
        public final PersistenceRegisterer createRegisterer() {
            return this.registererCreator.createRegisterer(this.objectManager, this.typeHandlerManager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long store(Object object) {
            long objectId;
            PersistenceStorer persister = this.createStorer();
            Object object2 = this.storeMutex;
            synchronized (object2) {
                objectId = persister.store(object);
                persister.commit();
            }
            return objectId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long[] storeAll(Object ... instances) {
            long[] objectIds;
            PersistenceStorer persister = this.createStorer();
            Object object = this.storeMutex;
            synchronized (object) {
                objectIds = persister.storeAll(instances);
                persister.commit();
            }
            return objectIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void storeAll(Iterable<?> instances) {
            PersistenceStorer persister = this.createStorer();
            Object object = this.storeMutex;
            synchronized (object) {
                persister.storeAll(instances);
                persister.commit();
            }
        }

        @Override
        public final long ensureObjectId(Object object) {
            this.typeHandlerManager.ensureTypeHandler(object.getClass());
            return this.objectManager.ensureObjectId(object);
        }

        @Override
        public final <T> long ensureObjectId(T object, PersistenceObjectIdRequestor<D> objectIdRequestor, PersistenceTypeHandler<D, T> optionalHandler) {
            this.typeHandlerManager.ensureTypeHandler(object.getClass());
            return this.objectManager.ensureObjectId(object, objectIdRequestor, optionalHandler);
        }

        @Override
        public final <T> long ensureObjectIdGuaranteedRegister(T object, PersistenceObjectIdRequestor<D> objectIdRequestor, PersistenceTypeHandler<D, T> optionalHandler) {
            this.typeHandlerManager.ensureTypeHandler(object.getClass());
            return this.objectManager.ensureObjectIdGuaranteedRegister(object, objectIdRequestor, optionalHandler);
        }

        @Override
        public long currentObjectId() {
            return this.objectManager.currentObjectId();
        }

        @Override
        public final long lookupObjectId(Object object) {
            return this.objectRegistry.lookupObjectId(object);
        }

        @Override
        public final Object lookupObject(long objectId) {
            return this.objectRegistry.lookupObject(objectId);
        }

        @Override
        public final boolean registerLocalRegistry(PersistenceLocalObjectIdRegistry<D> localRegistry) {
            return this.objectManager.registerLocalRegistry(localRegistry);
        }

        @Override
        public final void mergeEntries(PersistenceLocalObjectIdRegistry<D> localRegistry) {
            this.objectManager.mergeEntries(localRegistry);
        }

        @Override
        public final Object get() {
            return this.createLoader().get();
        }

        @Override
        public final <C extends Consumer<Object>> C collect(C collector, long ... objectIds) {
            return this.createLoader().collect(collector, objectIds);
        }

        @Override
        public final Object getObject(long objectId) {
            Object cachedInstance = this.objectManager.lookupObject(objectId);
            if (cachedInstance != null) {
                return cachedInstance;
            }
            return this.createLoader().getObject(objectId);
        }

        @Override
        public final PersistenceLoader createLoader() {
            return this.loaderCreator.createLoader(this.contextDispatcher.dispatchTypeHandlerLookup(this.typeHandlerManager), this.contextDispatcher.dispatchObjectRegistry(this.objectRegistry), this.getEffectivePersister(), this);
        }

        @Override
        public final PersistenceSource<D> source() {
            return this.source;
        }

        @Override
        public final PersistenceTarget<D> target() {
            return this.target;
        }

        @Override
        public synchronized void close() {
            this.target.closeTarget();
            this.source.closeSource();
        }

        @Override
        public synchronized Default<D> updateCurrentObjectId(long currentObjectId) {
            this.objectManager.updateCurrentObjectId(currentObjectId);
            return this;
        }

        @Override
        public synchronized void updateMetadata(PersistenceTypeDictionary typeDictionary, long highestTypeId, long highestObjectId) {
            this.typeHandlerManager.update(typeDictionary, highestTypeId);
            this.updateCurrentObjectId(highestObjectId);
        }
    }
}

