/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.java.dev.designgridlayout.AbstractRow;
import net.java.dev.designgridlayout.ComponentGapsHelper;
import net.java.dev.designgridlayout.EmptySubGrid;
import net.java.dev.designgridlayout.IExtractor;
import net.java.dev.designgridlayout.IGridRow;
import net.java.dev.designgridlayout.ISpannableGridRow;
import net.java.dev.designgridlayout.ISubGrid;
import net.java.dev.designgridlayout.LayoutHelper;
import net.java.dev.designgridlayout.MultiComponent;
import net.java.dev.designgridlayout.RowItem;
import net.java.dev.designgridlayout.SubGrid;
import net.java.dev.designgridlayout.SubList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GridRow
extends AbstractRow
implements ISpannableGridRow {
    private SubGrid _current = null;
    private int _gridIndex = 0;
    private int _totalGrids = 0;
    private final GridRow _previous;
    private final List<SubGrid> _grids = new ArrayList<SubGrid>();
    private final List<RowItem> _items = new ArrayList<RowItem>();
    private List<RowItem> _allItems = null;
    private static final ISubGrid NULL_GRID = new EmptySubGrid();

    GridRow(GridRow previous) {
        this._previous = previous;
    }

    @Override
    public ISpannableGridRow spanRow() {
        this._current.spanRow();
        return this;
    }

    @Override
    public ISpannableGridRow add(JComponent child, int span) {
        this._current.add(child, span);
        return this;
    }

    @Override
    public ISpannableGridRow add(JComponent ... children) {
        for (JComponent component : children) {
            this.add(component, 1);
        }
        return this;
    }

    @Override
    public ISpannableGridRow addMulti(int span, JComponent ... children) {
        return this.add((JComponent)new MultiComponent(this.growPolicy(), this.orientation(), children), span);
    }

    @Override
    public ISpannableGridRow addMulti(JComponent ... children) {
        return this.addMulti(1, children);
    }

    @Override
    public ISpannableGridRow empty() {
        return this.empty(1);
    }

    @Override
    public ISpannableGridRow empty(int span) {
        return this.add(null, span);
    }

    @Override
    public ISpannableGridRow grid(JLabel label) {
        return this.newGrid(label, 0);
    }

    @Override
    public ISpannableGridRow grid() {
        return this.newGrid(null, 0);
    }

    @Override
    public IGridRow grid(int gridspan) {
        return this.newGrid(null, gridspan);
    }

    @Override
    public IGridRow grid(JLabel label, int gridspan) {
        return this.newGrid(label, gridspan);
    }

    private ISpannableGridRow newGrid(JLabel label, int gridspan) {
        if (this._current != null) {
            this._current.gridspan(1);
            this._gridIndex += this._current.gridspan();
        }
        SubGrid previous = this._previous != null ? this._previous.findGrid(this._gridIndex) : null;
        this._current = new SubGrid(new SubList(this._items), previous, this.parent(), label, gridspan);
        this._grids.add(this._current);
        return this;
    }

    @Override
    void checkSpanRows() {
        for (SubGrid grid : this._grids) {
            grid.checkSpanRows();
        }
    }

    @Override
    int gridspan(int grid) {
        return this.findNonNulGrid(grid).gridspan();
    }

    @Override
    int labelWidth(int grid) {
        return this.findNonNulGrid(grid).labelWidth();
    }

    @Override
    int numGrids() {
        int numGrids = 0;
        for (SubGrid grid : this._grids) {
            numGrids += grid.gridspan() > 0 ? grid.gridspan() : 1;
        }
        return numGrids;
    }

    @Override
    void totalGrids(int totalGrids) {
        int span = totalGrids;
        Iterator<SubGrid> i = this._grids.iterator();
        while (i.hasNext()) {
            SubGrid grid = i.next();
            if (i.hasNext()) {
                span -= grid.gridspan();
                continue;
            }
            grid.gridspan(span);
        }
        this._totalGrids = totalGrids;
    }

    @Override
    int gridColumns(int grid) {
        return this.findNonNulGrid(grid).gridColumns();
    }

    @Override
    int maxColumnWidth(int grid, int maxColumns, IExtractor extractor) {
        return this.findNonNulGrid(grid).maxColumnWidth(maxColumns, extractor);
    }

    @Override
    int hgap() {
        int hgap = 0;
        for (SubGrid grid : this._grids) {
            hgap = Math.max(hgap, grid.hgap());
        }
        return hgap;
    }

    @Override
    int gridgap() {
        ComponentGapsHelper helper = ComponentGapsHelper.instance();
        int gridgap = 0;
        for (int i = 0; i < this._grids.size() - 1; ++i) {
            List<RowItem> leftGrid = this._grids.get(i).items();
            List<RowItem> rightGrid = this._grids.get(i + 1).items();
            if (leftGrid.isEmpty() || rightGrid.isEmpty()) continue;
            JComponent left = leftGrid.get(leftGrid.size() - 1).component();
            JComponent right = rightGrid.get(0).component();
            int gap = helper.getHorizontalGap(left, right, 1, this.parent());
            gridgap = Math.max(gridgap, gap);
        }
        return gridgap;
    }

    @Override
    boolean isEmpty() {
        for (SubGrid grid : this._grids) {
            if (grid.leftComponent() == null) continue;
            return false;
        }
        return true;
    }

    @Override
    JComponent leftComponent() {
        return this._grids.isEmpty() ? null : this._grids.get(0).leftComponent();
    }

    List<RowItem> items() {
        return this._items;
    }

    List<RowItem> allItems() {
        if (this._allItems == null) {
            this._allItems = new ArrayList<RowItem>(this._items.size() + this._grids.size());
            for (SubGrid grid : this._grids) {
                if (grid.label() != null) {
                    this._allItems.add(new RowItem(1, grid.label()));
                }
                this._allItems.addAll(grid.items());
            }
        }
        return this._allItems;
    }

    @Override
    int layoutRow(LayoutHelper helper, int left, int hgap, int gridgap, int rowWidth, int gridsWidth, List<Integer> labelsWidth) {
        int x = left;
        int actualHeight = 0;
        int gridWidth = gridsWidth / this._totalGrids;
        int gridIndex = 0;
        Iterator<Integer> label = labelsWidth.iterator();
        for (SubGrid grid : this._grids) {
            int labelWidth = label.next();
            int width = gridWidth;
            for (int i = 1; i < grid.gridspan(); ++i) {
                width += gridgap + label.next() + hgap + gridWidth;
            }
            if ((gridIndex += grid.gridspan()) == this._totalGrids) {
                int fudge = gridsWidth % this._totalGrids;
                width += fudge;
            }
            int height = grid.layoutRow(helper, x, this.height(), this.baseline(), hgap, width, labelWidth);
            actualHeight = Math.max(actualHeight, height);
            x += labelWidth + hgap + width + gridgap;
        }
        return actualHeight;
    }

    SubGrid findGrid(int index) {
        int i = 0;
        for (SubGrid grid : this._grids) {
            if (i == index) {
                return grid;
            }
            if ((i += grid.gridspan()) <= index) continue;
            break;
        }
        return null;
    }

    private ISubGrid findNonNulGrid(int index) {
        SubGrid grid = this.findGrid(index);
        return grid != null ? grid : NULL_GRID;
    }
}

