/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.java.dev.designgridlayout.MultiComponent;
import org.jdesktop.layout.Baseline;

final class BaselineHelper {
    private static final boolean _isJava6;
    private static final Set<Class<? extends JComponent>> _centerAlignedComponents;

    private BaselineHelper() {
    }

    public static int getBaseline(Component comp) {
        Dimension size = comp.getPreferredSize();
        int baseline = BaselineHelper.getBaseline(comp, size.width, size.height);
        if (baseline < 0) {
            boolean isCenter = false;
            for (Class<? extends JComponent> clazz : _centerAlignedComponents) {
                if (!clazz.isInstance(comp)) continue;
                isCenter = true;
                break;
            }
            if (!isCenter) {
                baseline = 0;
            }
        }
        return baseline;
    }

    private static int getBaseline(Component comp, int width, int height) {
        if (!(comp instanceof JComponent)) {
            return -1;
        }
        if (_isJava6) {
            return Baseline.getBaseline((JComponent)((JComponent)comp), (int)width, (int)height);
        }
        if (comp instanceof JScrollPane) {
            return BaselineHelper.getScrollPaneBaseline((JScrollPane)comp, width, height);
        }
        if (comp instanceof JTableHeader) {
            return BaselineHelper.getTableHeaderBaseline((JTableHeader)comp, width, height);
        }
        if (comp instanceof MultiComponent) {
            Dimension size = comp.getPreferredSize();
            return ((MultiComponent)comp).getBaseline(size.width, size.height);
        }
        return Baseline.getBaseline((JComponent)((JComponent)comp), (int)width, (int)height);
    }

    private static int getTableHeaderBaseline(JTableHeader header, int width, int height) {
        TableColumnModel columnModel = header.getColumnModel();
        if (columnModel.getColumnCount() == 0) {
            return -1;
        }
        TableColumn column = columnModel.getColumn(0);
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = header.getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(header.getTable(), column.getHeaderValue(), false, false, -1, 0);
        Dimension pref = comp.getPreferredSize();
        return BaselineHelper.getBaseline(comp, pref.width, height);
    }

    private static int getScrollPaneBaseline(JScrollPane sp, int width, int height) {
        int baseline;
        Insets spInsets = sp.getInsets();
        int y = spInsets.top;
        width -= spInsets.left + spInsets.right;
        height -= spInsets.top + spInsets.bottom;
        JViewport columnHeader = sp.getColumnHeader();
        if (columnHeader != null && columnHeader.isVisible()) {
            int baseline2;
            Component header = columnHeader.getView();
            if (header != null && header.isVisible() && (baseline2 = BaselineHelper.getBaseline(header)) >= 0) {
                return y + baseline2;
            }
            Dimension columnPref = columnHeader.getPreferredSize();
            height -= columnPref.height;
            y += columnPref.height;
        }
        if ((baseline = BaselineHelper.getViewportBaseline(sp, width, height)) >= 0) {
            return y + baseline;
        }
        return -1;
    }

    private static int getViewportBaseline(JScrollPane sp, int width, int height) {
        Component view;
        JViewport viewport = sp.getViewport();
        Component component = view = viewport == null ? null : viewport.getView();
        if (view != null && view.isVisible()) {
            int baseline;
            int y = 0;
            Border viewportBorder = sp.getViewportBorder();
            if (viewportBorder != null) {
                Insets vpbInsets = viewportBorder.getBorderInsets(sp);
                y = vpbInsets.top;
                width -= vpbInsets.left + vpbInsets.right;
                height -= vpbInsets.top + vpbInsets.bottom;
            }
            if (view.getWidth() > 0 && view.getHeight() > 0) {
                Dimension min = view.getMinimumSize();
                width = Math.max(min.width, view.getWidth());
                height = Math.max(min.height, view.getHeight());
            }
            if (width > 0 && height > 0 && (baseline = BaselineHelper.getBaseline(view)) > 0) {
                return y + baseline;
            }
        }
        return -1;
    }

    static {
        boolean isJava6;
        try {
            Component.class.getMethod("getBaseline", Integer.TYPE, Integer.TYPE);
            isJava6 = true;
        }
        catch (Exception e) {
            isJava6 = false;
        }
        _isJava6 = isJava6;
        _centerAlignedComponents = new HashSet<Class<? extends JComponent>>();
        _centerAlignedComponents.add(JSeparator.class);
        _centerAlignedComponents.add(JProgressBar.class);
    }
}

