/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import net.java.dev.designgridlayout.AbstractRow;
import net.java.dev.designgridlayout.ComponentHelper;
import net.java.dev.designgridlayout.IExtractor;
import net.java.dev.designgridlayout.INonGridRow;
import net.java.dev.designgridlayout.LayoutHelper;
import net.java.dev.designgridlayout.MultiComponent;
import net.java.dev.designgridlayout.NonGridRowItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNonGridRow
extends AbstractRow
implements INonGridRow {
    private final List<NonGridRowItem> _items = new ArrayList<NonGridRowItem>();
    private boolean _fill = false;

    AbstractNonGridRow() {
    }

    @Override
    public INonGridRow add(JComponent ... children) {
        for (JComponent component : children) {
            this._items.add(new NonGridRowItem(component));
            this.parent().add(component);
        }
        return this;
    }

    @Override
    public INonGridRow addMulti(JComponent ... children) {
        return this.add(new MultiComponent(this.growPolicy(), this.orientation(), children));
    }

    @Override
    public INonGridRow fill() {
        this._fill = true;
        return this;
    }

    @Override
    void checkSpanRows() {
    }

    List<NonGridRowItem> items() {
        return this._items;
    }

    @Override
    int totalNonGridWidth(int hgap, IExtractor extractor) {
        int compWidth = ComponentHelper.maxValues(this._items, extractor);
        int count = this._items.size();
        int width = compWidth * count + hgap * (count - 1);
        return width;
    }

    @Override
    int layoutRow(LayoutHelper helper, int left, int hgap, int gridgap, int rowWidth, int gridsWidth, List<Integer> labelsWidth) {
        int x = left;
        int count = this._items.size();
        int width = this.maxWidth();
        int availableWidth = rowWidth - (count - 1) * hgap;
        int leftFiller = width = Math.min(width, availableWidth / count);
        int rightFiller = width;
        if (!this._fill) {
            int usedWidth = width * count + (count - 1) * hgap;
            x += this.xOffset(rowWidth, usedWidth);
        } else {
            int usedWidth = availableWidth;
            leftFiller = this.leftFiller(count, width, usedWidth);
            rightFiller = this.rightFiller(count, width, usedWidth);
        }
        return this.layoutRow(helper, x, hgap, width, leftFiller, rightFiller);
    }

    protected int layoutRow(LayoutHelper helper, int left, int hgap, int width, int leftFiller, int rightFiller) {
        int x = left;
        int count = this._items.size();
        int i = 0;
        int actualHeight = 0;
        for (NonGridRowItem item : this._items) {
            int compWidth = i == 0 ? leftFiller : (i == count - 1 ? rightFiller : width);
            actualHeight = Math.max(actualHeight, helper.setSizeLocation(item.component(), x, compWidth, this.height(), this.baseline()));
            x += compWidth + hgap;
            ++i;
        }
        return actualHeight;
    }

    protected abstract int xOffset(int var1, int var2);

    protected abstract int leftFiller(int var1, int var2, int var3);

    protected abstract int rightFiller(int var1, int var2, int var3);
}

