/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.util.filter;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.I18NText;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.util.EqualsBuilder;
import com.schneide.base.util.filter.AbstractReadableFilter;
import com.schneide.base.util.filter.FilterVisitor;
import com.schneide.base.util.filter.ReadableFilter;

public abstract class AbstractSingleOperatorFilter<E>
extends AbstractReadableFilter<E> {
    private final ReadableFilter<E> one;

    protected AbstractSingleOperatorFilter(ReadableFilter<E> one) {
        this.one = one;
    }

    @Override
    public <V> V acceptVisitor(FilterVisitor<V> visitor) {
        return visitor.visit(this);
    }

    public ReadableFilter<E> getOne() {
        return this.one;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.isEqual(this, obj);
    }

    public int hashCode() {
        return EqualsBuilder.hashCodeFor(this);
    }

    public Iterable<Object> getValuesToCompare() {
        return new SingleElementIterable<Object>(this.one);
    }

    public abstract I18NKey getOperatorDenotation();

    @Override
    public I18NResolvable getDenotation() {
        return new I18NText(this.getOperatorDenotation(), this.one.getDenotation());
    }
}

