/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.util;

public final class HexadecimalConverter {
    private static final int HEXADECIMAL_BASE = 16;
    private static final int BITMASK_SHIFT = 4;

    private HexadecimalConverter() {
    }

    public static String convertToHexadecimal(byte value) {
        return HexadecimalConverter.convertToHexadecimal(256 + (value & 0xFF), 2);
    }

    public static String convertToHexadecimal(int value, int digitCount) {
        int bitMask = HexadecimalConverter.getBitMaskFor(digitCount);
        return Integer.toHexString(value & bitMask | bitMask + 1).toUpperCase().substring(1, digitCount + 1);
    }

    public static int getBitMaskFor(int digitCount) {
        int result = 1;
        for (int i = 0; i < digitCount; ++i) {
            result <<= 4;
        }
        return result - 1;
    }

    public static int convertFromHexadecimal(String valueRepresentation) throws NumberFormatException {
        return Integer.parseInt(valueRepresentation, 16);
    }
}

