/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.util;

import com.schneide.base.util.HexadecimalConverter;
import java.nio.charset.Charset;

public final class ByteUtil {
    private ByteUtil() {
    }

    public static byte[] shortToLittleEndianBytes(short s) {
        return new byte[]{(byte)(s % 256), (byte)(s >> 8)};
    }

    public static byte[] intToLittleEndianBytes(int i) {
        return new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8), (byte)((i & 0xFF0000) >> 16), (byte)((i & 0xFF000000) >> 24)};
    }

    public static byte[] intToTwoLittleEndianShortBytes(int i) {
        return new byte[]{(byte)((i & 0xFF0000) >> 16), (byte)((i & 0xFF000000) >> 24), (byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8)};
    }

    public static int byteToInt(byte b) {
        if (b >= 0) {
            return b;
        }
        return b & 0xFF;
    }

    public static void copyIntoArray(byte[] source, byte[] destination, int destinationIndex) {
        System.arraycopy(source, 0, destination, destinationIndex, source.length);
    }

    public static void copyIntoArray(short source, byte[] destination, int destinationIndex) {
        ByteUtil.copyIntoArray(ByteUtil.shortToLittleEndianBytes(source), destination, destinationIndex);
    }

    public static byte[] stringToASCIIBytes(String s) {
        return s.getBytes(Charset.forName("ASCII"));
    }

    public static int copyIntoArray(byte b, byte[] destination, int destinationIndex, int length) {
        for (int i = destinationIndex; i < destinationIndex + length; ++i) {
            destination[i] = b;
        }
        return length;
    }

    public static String toHexString(byte b) {
        return "0x" + HexadecimalConverter.convertToHexadecimal(b);
    }
}

