/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.timing;

import com.schneide.base.logging.LoggedObject;
import com.schneide.base.timing.DelayMeasurer;

public class Timing
extends LoggedObject {
    private final DelayMeasurer delay;
    private String name;

    public Timing() {
        this(String.valueOf(System.currentTimeMillis()));
    }

    public Timing(String name) {
        this.name = name;
        this.delay = new DelayMeasurer();
    }

    public void stop() {
        this.delay.stop();
    }

    public void stopAndReport() {
        this.stop();
        this.getLogger().debug(this.getReportMessage());
    }

    public void stopAndReport(String newName) {
        this.name = newName;
        this.stopAndReport();
    }

    protected DelayMeasurer getDelay() {
        return this.delay;
    }

    public String getName() {
        return this.name;
    }

    public String getReportMessage() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getName());
        buffer.append(" took ");
        buffer.append(this.getDelay().getReadableShowtime());
        return buffer.toString();
    }
}

