/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.timing;

import com.schneide.base.datetime.Time;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.base.text.transformation.Fillup;

public class DelayMeasurer {
    private final long nanoStart;
    private long nanoEnd;

    public DelayMeasurer() {
        this(DelayMeasurer.getCurrentNanoTime());
    }

    public DelayMeasurer(long startingNanos) {
        this.nanoStart = startingNanos;
        this.nanoEnd = -1L;
    }

    protected static long getCurrentNanoTime() {
        return System.nanoTime();
    }

    public long peek() {
        return this.getDelta(DelayMeasurer.getCurrentNanoTime());
    }

    private long getDelta(long endingNanos) {
        return endingNanos - this.nanoStart;
    }

    public long stop() {
        this.nanoEnd = DelayMeasurer.getCurrentNanoTime();
        return this.getDelay();
    }

    public long getDelay() {
        if (!this.isStopped()) {
            return -1L;
        }
        return this.getDelta(this.nanoEnd);
    }

    public boolean isStopped() {
        return -1L != this.nanoEnd;
    }

    public String getReadableShowtime() {
        if (this.getDelay() < 0L) {
            return "<n/a>";
        }
        DirectChunkBuffer buffer = new DirectChunkBuffer(",");
        buffer.add(Time.formatTimeInMilliseconds(this.getMillisecondDelay()));
        buffer.add(Fillup.leadingWith("0", 3, String.valueOf((Object)(this.getMillisecondDelay() % 1000L))));
        return ((Object)buffer).toString();
    }

    public long getMillisecondDelay() {
        return this.getDelay() / 1000000L;
    }
}

