/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.threading.delay;

import com.schneide.base.threading.SchneideThread;
import com.schneide.base.threading.delay.Delay;
import javax.measure.Measurable;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;

public class GenericDelay
implements Delay {
    public static final GenericDelay none = new GenericDelay(0L, 0L);
    private final long leading;
    private final long trailing;

    public GenericDelay(Measurable<Duration> leading, Measurable<Duration> trailing) {
        this(GenericDelay.inMilliseconds(leading), GenericDelay.inMilliseconds(trailing));
    }

    protected static long inMilliseconds(Measurable<Duration> timespan) {
        return timespan.longValue(SI.MILLI((Unit)SI.SECOND));
    }

    public GenericDelay(long leading, long trailing) {
        this.leading = leading;
        this.trailing = trailing;
    }

    @Override
    public void performLeading() {
        GenericDelay.sleep(this.leading);
    }

    @Override
    public void performTrailing() {
        GenericDelay.sleep(this.trailing);
    }

    @Override
    public void performComplete() {
        this.performLeading();
        this.performTrailing();
    }

    @Override
    public java.time.Duration asDuration() {
        return java.time.Duration.ofMillis(this.leading + this.trailing);
    }

    public static final void sleep(Measurable<Duration> timespan) {
        GenericDelay.sleep(GenericDelay.inMilliseconds(timespan));
    }

    public static final void sleep(long milliseconds) {
        SchneideThread.performDelay(milliseconds);
    }

    public final void yield() {
        Thread.yield();
    }

    public String toString() {
        return this.leading + ";" + this.trailing;
    }
}

