/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.threading.consumer;

import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.threading.LoopingExecutable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;

public class Processor<BIT>
extends LoggedObject
implements LifeCycle {
    private final BlockingQueue<BIT> pendingBits;
    private final LoopingExecutable consumerThread;
    private final String bitDenotation;
    private final Consumer<BIT> sink;

    public Processor(String bitDenotation, String threadDenotation, Consumer<BIT> sink) {
        this.bitDenotation = bitDenotation;
        this.sink = sink;
        this.pendingBits = new LinkedBlockingQueue<BIT>();
        this.consumerThread = new LoopingExecutable(threadDenotation, true){

            @Override
            protected void executeWithinLoop() throws Exception {
                Processor.this.consumeNextBit();
            }
        };
    }

    @Override
    public void start() {
        this.consumerThread.startExecution();
    }

    @Override
    public void stop() {
        this.consumerThread.stopWithInterrupt();
    }

    public void append(BIT producedBit) {
        if (this.consumerThread.isStopRequested()) {
            this.getLogger().warn("Not queuing anymore, because the consumer thread is stopped.");
            return;
        }
        try {
            this.pendingBits.put(producedBit);
        }
        catch (InterruptedException e) {
            this.getLogger().error("Could not queue " + this.bitDenotation + ": " + String.valueOf(producedBit), e);
        }
    }

    protected void consumeNextBit() {
        block2: {
            try {
                BIT nextBit = this.pendingBits.take();
                this.sink.accept(nextBit);
            }
            catch (InterruptedException e) {
                if (this.consumerThread.isStopRequested()) break block2;
                this.getLogger().error("Could not consume next queued " + this.bitDenotation, e);
            }
        }
    }
}

