/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.threading;

import com.schneide.base.datatypes.collections.CollectionUtil;
import com.schneide.base.threading.SchneideThread;
import java.util.ArrayList;

public final class SchneideThreadHelper {
    private SchneideThreadHelper() {
    }

    public static Iterable<SchneideThread> getRunningSchneideThreads() {
        ThreadGroup root = Thread.currentThread().getThreadGroup().getParent();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return SchneideThreadHelper.findRunningSchneideThreads(root);
    }

    private static Iterable<SchneideThread> findRunningSchneideThreads(ThreadGroup group) {
        ArrayList<SchneideThread> result = new ArrayList<SchneideThread>();
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = group.enumerate(threads, false);
        for (int i = 0; i < numThreads; ++i) {
            if (!(threads[i] instanceof SchneideThread)) continue;
            result.add((SchneideThread)threads[i]);
        }
        int numGroups = group.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
        numGroups = group.enumerate(groups, false);
        for (int i = 0; i < numGroups; ++i) {
            Iterable<SchneideThread> threadBatch = SchneideThreadHelper.findRunningSchneideThreads(groups[i]);
            CollectionUtil.addAll(result, threadBatch);
        }
        return result;
    }
}

