/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text.transformation;

import com.schneide.base.text.buffer.DirectChunkBuffer;

public final class StringJoin {
    private StringJoin() {
    }

    public static <T> String commaSeparated(Iterable<T> objects) {
        return StringJoin.commaSeparated(objects, new SimpleJoinFormatter());
    }

    public static <T> String commaSeparated(Iterable<T> objects, StringJoinFormatter<T> formatter) {
        return StringJoin.separatedBy(objects, ", ", formatter);
    }

    public static <T> String separatedBy(Iterable<T> objects, String separator) {
        return StringJoin.separatedBy(objects, separator, new SimpleJoinFormatter());
    }

    public static <T> String separatedBy(Iterable<T> objects, String separator, StringJoinFormatter<T> formatter) {
        DirectChunkBuffer buffer = new DirectChunkBuffer(separator);
        for (T object : objects) {
            buffer.add(formatter.format(object));
        }
        return ((Object)buffer).toString();
    }

    private static final class SimpleJoinFormatter<T>
    implements StringJoinFormatter<T> {
        @Override
        public String format(T item) {
            return String.valueOf(item);
        }
    }

    public static interface StringJoinFormatter<T> {
        public String format(T var1);
    }
}

