/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text.transformation;

import com.schneide.base.text.transformation.StringTransformation;

public class PrefixTrim
implements StringTransformation {
    private final String prefixPattern;

    public PrefixTrim(String prefixPattern) {
        this.prefixPattern = prefixPattern;
    }

    @Override
    public String transform(String string) {
        String result = string;
        if (this.prefixPattern != null && this.prefixPattern.length() > 0) {
            while (result.length() >= this.prefixPattern.length() && result.startsWith(this.prefixPattern)) {
                result = result.substring(this.prefixPattern.length(), result.length());
            }
        }
        return result;
    }

    public String getPrefixPattern() {
        return this.prefixPattern;
    }
}

