/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text.transformation;

public class LineBreaker {
    private final int maximalLineLength;

    public LineBreaker(int maximalLineLength) {
        this.maximalLineLength = maximalLineLength;
    }

    public String getWrapped(String newMessage) {
        LineBreak lineBreak;
        StringBuilder buffer = new StringBuilder();
        for (int startPosition = 0; startPosition < newMessage.length(); startPosition += lineBreak.getPosition()) {
            int endPosition = Math.min(newMessage.length(), startPosition + this.maximalLineLength);
            String possibleLine = newMessage.substring(startPosition, endPosition);
            lineBreak = this.getBestLineBreakFor(possibleLine);
            buffer.append(newMessage.substring(startPosition, startPosition + lineBreak.getPosition()));
            buffer.append(lineBreak.getPostfix());
        }
        return buffer.toString();
    }

    protected LineBreak getBestLineBreakFor(String possibleLine) {
        if (possibleLine.trim().contains("\n")) {
            return new ExistingLineBreak(possibleLine.indexOf("\n") + 1);
        }
        if (this.maximalLineLength > possibleLine.length()) {
            return new ExistingLineBreak(possibleLine.length());
        }
        if (possibleLine.trim().contains(" ")) {
            return new ForcedLineBreak(possibleLine.lastIndexOf(" ") + 1);
        }
        return new ForcedLineBreak(possibleLine.length());
    }

    protected static interface LineBreak {
        public int getPosition();

        public String getPostfix();
    }

    protected static class ExistingLineBreak
    implements LineBreak {
        private final int position;

        public ExistingLineBreak(int position) {
            this.position = position;
        }

        @Override
        public String getPostfix() {
            return "";
        }

        @Override
        public int getPosition() {
            return this.position;
        }
    }

    protected static class ForcedLineBreak
    implements LineBreak {
        private final int position;

        public ForcedLineBreak(int position) {
            this.position = position;
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public String getPostfix() {
            return "\n";
        }
    }
}

