/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text.transformation;

import java.util.ArrayList;
import java.util.List;

public final class KeepOnly {
    private final List<Inclusion> inclusions = new ArrayList<Inclusion>();
    private static final Inclusion ASCII_LETTERS = character -> Character.isLetter(character) && character < '\u0080';
    private static final Inclusion LETTERS = character -> Character.isLetter(character);
    private static final Inclusion DIGITS = character -> Character.isDigit(character);
    private static final Inclusion WHITESPACES = character -> Character.isWhitespace(character);

    private KeepOnly() {
    }

    protected void withInclusion(Inclusion inclusion) {
        this.inclusions.add(inclusion);
    }

    public static KeepOnly letters() {
        return new KeepOnly().andLetters();
    }

    public static KeepOnly asciiLetters() {
        return new KeepOnly().andAsciiLetters();
    }

    public KeepOnly andLetters() {
        this.withInclusion(LETTERS);
        return this;
    }

    public KeepOnly andAsciiLetters() {
        this.withInclusion(ASCII_LETTERS);
        return this;
    }

    public static KeepOnly digits() {
        return new KeepOnly().andDigits();
    }

    public KeepOnly andDigits() {
        this.withInclusion(DIGITS);
        return this;
    }

    public static KeepOnly whitespaces() {
        return new KeepOnly().andWhitespaces();
    }

    public KeepOnly andWhitespaces() {
        this.withInclusion(WHITESPACES);
        return this;
    }

    public String from(String text) {
        StringBuilder result = new StringBuilder();
        for (char character : text.toCharArray()) {
            for (Inclusion inclusion : this.inclusions) {
                if (!inclusion.appliesTo(character)) continue;
                result.append(character);
            }
        }
        return result.toString();
    }

    protected static interface Inclusion {
        public boolean appliesTo(char var1);
    }
}

