/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text.transformation;

public final class Disbrace {
    private Disbrace() {
    }

    public static String fromSquareBrackets(CharSequence text) {
        return Disbrace.stripFrom("[", "]", text);
    }

    public static String fromParentheses(CharSequence text) {
        return Disbrace.fromRoundBrackets(text);
    }

    public static String fromRoundBrackets(CharSequence text) {
        return Disbrace.stripFrom("(", ")", text);
    }

    public static String fromSlashes(CharSequence text) {
        return Disbrace.stripFrom("/", "/", text);
    }

    public static String fromDoubleQuotes(CharSequence text) {
        return Disbrace.stripFrom("\"", "\"", text);
    }

    protected static String stripFrom(String leading, String trailing, CharSequence text) {
        if (null == text) {
            return null;
        }
        String result = text.toString();
        int start = 0;
        int end = text.length();
        if (result.startsWith(leading)) {
            start += leading.length();
        }
        if (result.endsWith(trailing)) {
            end -= trailing.length();
        }
        return result.substring(start, Math.max(start, end));
    }
}

