/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text.parsing;

import com.schneide.base.datatypes.collections.ArrayUtil;
import com.schneide.base.text.parsing.DelimiterSet;
import java.util.ArrayList;
import java.util.Iterator;

public class StringChunker
implements Iterable<String>,
Iterator<String> {
    private static final DelimiterSet DEFAULT_DELIMITERS = new DelimiterSet(" \t\n\r\f");
    private final String text;
    private final DelimiterSet delimiters;
    private boolean ignoreMultipleDelimiters;
    private boolean canReturnNull;
    private boolean ignoreLeadingDelimiters;
    private boolean ignoreTrailingDelimiters;
    private int position;
    private String nextChunk;
    private boolean lastPositionChunkProvided;

    public StringChunker(String text) {
        this(text, DEFAULT_DELIMITERS);
    }

    public StringChunker(String text, boolean ignoreMultipleDelimiters) {
        this(text, DEFAULT_DELIMITERS, ignoreMultipleDelimiters);
    }

    public StringChunker(String text, String delimiters) {
        this(text, new DelimiterSet(delimiters));
    }

    public StringChunker(String text, String delimiters, boolean ignoreMultipleDelimiters) throws IllegalArgumentException {
        this(text, new DelimiterSet(delimiters), ignoreMultipleDelimiters);
    }

    public StringChunker(String text, DelimiterSet delimiters) {
        this(text, delimiters, false);
    }

    public StringChunker(String text, DelimiterSet delimiters, boolean ignoreMultipleDelimiters) {
        this.text = text;
        this.delimiters = delimiters;
        this.ignoreMultipleDelimiters = ignoreMultipleDelimiters;
        this.canReturnNull = true;
        this.position = 0;
        this.nextChunk = null;
        this.lastPositionChunkProvided = false;
        this.ignoreLeadingDelimiters = false;
        this.ignoreTrailingDelimiters = false;
    }

    public boolean ignoresMultipleDelimiters() {
        return this.ignoreMultipleDelimiters;
    }

    public void setIgnoreMultipleDelimiters(boolean ignoreMultipleDelimiters) {
        this.ignoreMultipleDelimiters = ignoreMultipleDelimiters;
    }

    private int getDelimiterCount() {
        int result = 0;
        while (this.hasCharactersLeft() && this.isCurrentCharacterDelimiter()) {
            ++this.position;
            ++result;
        }
        return result;
    }

    public void setIgnoreLeadingDelimiters(boolean ignoreLeadingDelimiters) {
        this.ignoreLeadingDelimiters = ignoreLeadingDelimiters;
    }

    public void setIgnoreTrailingDelimiters(boolean ignoreTrailingDelimiters) {
        this.ignoreTrailingDelimiters = ignoreTrailingDelimiters;
    }

    public void setIgnoreLeadingAndTrailingDelimiters(boolean ignoranceMode) {
        this.setIgnoreLeadingDelimiters(ignoranceMode);
        this.setIgnoreTrailingDelimiters(ignoranceMode);
    }

    public boolean ignoresLeadingDelimiters() {
        return this.ignoreLeadingDelimiters;
    }

    public boolean ignoresTrailingDelimiters() {
        return this.ignoreTrailingDelimiters;
    }

    private boolean hasCharactersLeft() {
        return this.position < this.text.length();
    }

    public boolean hasMoreChunks() {
        if (null == this.text) {
            return false;
        }
        if (null != this.nextChunk) {
            return true;
        }
        if (0 == this.position && this.ignoresLeadingDelimiters()) {
            this.position = this.getDelimiterCount();
        }
        if (this.hasCharactersLeft()) {
            return this.parseNextChunk();
        }
        if (this.wasLastCharacterDelimiter() && !this.lastPositionChunkProvided && !this.ignoreTrailingDelimiters) {
            this.lastPositionChunkProvided = true;
            this.nextChunk = "";
            return true;
        }
        this.nextChunk = null;
        return false;
    }

    private boolean parseNextChunk() {
        int startPosition = this.position;
        int delimiterCount = 0;
        while (this.hasCharactersLeft()) {
            if (this.isCurrentCharacterDelimiter()) {
                ++this.position;
                ++delimiterCount;
                if (!this.ignoresMultipleDelimiters()) break;
                delimiterCount += this.getDelimiterCount();
                break;
            }
            ++this.position;
        }
        if (startPosition < this.position) {
            int offset = this.getOffset(delimiterCount);
            this.nextChunk = this.text.substring(startPosition, this.position + offset);
            if (this.isIgnoredTrailingDelimiterChunk()) {
                this.nextChunk = null;
                return false;
            }
            return true;
        }
        this.nextChunk = null;
        return false;
    }

    private boolean isIgnoredTrailingDelimiterChunk() {
        return this.ignoresTrailingDelimiters() && this.position > this.text.length() && 0 == this.nextChunk.length();
    }

    private boolean wasLastCharacterDelimiter() {
        if (this.position > 0) {
            return this.isDelimiter(this.text.charAt(this.position - 1));
        }
        return false;
    }

    private boolean isDelimiter(char character) {
        return this.delimiters.isDelimiter(character);
    }

    private boolean isCurrentCharacterDelimiter() {
        char currentCharacter = this.text.charAt(this.position);
        return this.isDelimiter(currentCharacter);
    }

    private int getOffset(int delimiterCount) {
        if (this.delimiters.isHidden()) {
            return -delimiterCount;
        }
        return 0;
    }

    public String getNextChunk() {
        if (this.hasMoreChunks()) {
            String result = this.nextChunk;
            this.nextChunk = null;
            return result;
        }
        return this.getNullChunk();
    }

    private String getNullChunk() {
        if (this.canReturnNull()) {
            return null;
        }
        return "";
    }

    public void setCanReturnNull(boolean canReturnNull) {
        this.canReturnNull = canReturnNull;
    }

    public boolean canReturnNull() {
        return this.canReturnNull;
    }

    public int getPosition() {
        return this.position;
    }

    public String getRemainingString() {
        return this.text.substring(this.getPosition());
    }

    public String getLastChunk() {
        String result = null;
        while (this.hasMoreChunks()) {
            result = this.getNextChunk();
        }
        return result;
    }

    @Override
    public Iterator<String> iterator() {
        StringChunker result = new StringChunker(this.text, this.delimiters, this.ignoreMultipleDelimiters);
        result.setIgnoreLeadingDelimiters(this.ignoreLeadingDelimiters);
        result.setIgnoreTrailingDelimiters(this.ignoreTrailingDelimiters);
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreChunks();
    }

    @Override
    public String next() {
        return this.getNextChunk();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }

    public Iterable<String> getAllChunks() {
        ArrayList<String> result = new ArrayList<String>();
        while (this.hasMoreChunks()) {
            result.add(this.getNextChunk());
        }
        return result;
    }

    public String[] getAllChunksAsArray() {
        return ArrayUtil.createArray(String.class, this.getAllChunks());
    }
}

