/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text;

import com.schneide.base.text.StringUtil;
import com.schneide.base.text.transformation.TextModification;
import java.util.Locale;

public class Text
implements CharSequence {
    public static final String empty = "";
    public static final String space = " ";
    public static final String blank = " ";
    public static final String newline = "\n";
    public static final String underscore = "_";
    public static final String dash = "-";
    public static final String bullet = "\u2022";
    private final String text;

    public Text() {
        this(empty);
    }

    public Text(String text) {
        this.text = text;
    }

    public boolean contains(String substring) {
        return Text.contains(this.getText(), substring);
    }

    public boolean containsNull() {
        return this.toString() == null;
    }

    public boolean isNull() {
        return this.containsNull();
    }

    public static boolean contains(String reference, String searchString) {
        return reference.indexOf(searchString) >= 0;
    }

    public static boolean containsIgnoreCase(String reference, String searchString) {
        return reference.toUpperCase().indexOf(searchString.toUpperCase()) >= 0;
    }

    public boolean isEmpty(boolean considerWhitespaces) {
        if (!considerWhitespaces) {
            return Text.isEmpty(this.trim());
        }
        return Text.isEmpty(this);
    }

    public static boolean isEmpty(Text string) {
        return Text.isEmpty(string.toString());
    }

    public static boolean isEmpty(String string) {
        return StringUtil.isEmptyOrNull(string);
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty(true);
    }

    public int getLength() {
        return this.length();
    }

    public int getSize() {
        return this.length();
    }

    public static String copyValueOf(char[] arg0) {
        return String.copyValueOf(arg0);
    }

    public static String copyValueOf(char[] arg0, int arg1, int arg2) {
        return String.copyValueOf(arg0, arg1, arg2);
    }

    public static String valueOf(boolean arg0) {
        return String.valueOf(arg0);
    }

    public static String valueOf(char arg0) {
        return String.valueOf(arg0);
    }

    public static String valueOf(char[] arg0) {
        return String.valueOf(arg0);
    }

    public static String valueOf(char[] arg0, int arg1, int arg2) {
        return String.valueOf(arg0, arg1, arg2);
    }

    public static String valueOf(double arg0) {
        return String.valueOf(arg0);
    }

    public static String valueOf(float arg0) {
        return String.valueOf(arg0);
    }

    public static String valueOf(int arg0) {
        return String.valueOf(arg0);
    }

    public static String valueOf(Object arg0) {
        return String.valueOf(arg0);
    }

    public static String valueOf(long arg0) {
        return String.valueOf(arg0);
    }

    @Override
    public char charAt(int arg0) {
        return this.getText().charAt(arg0);
    }

    public int compareTo(String arg0) {
        return this.getText().compareTo(arg0);
    }

    public int compareToIgnoreCase(String arg0) {
        return this.getText().compareToIgnoreCase(arg0);
    }

    public String concat(String arg0) {
        return this.getText().concat(arg0);
    }

    public boolean contentEquals(StringBuffer arg0) {
        return this.getText().contentEquals(arg0);
    }

    public boolean endsWith(String arg0) {
        return this.getText().endsWith(arg0);
    }

    public boolean equalsIgnoreCase(String arg0) {
        return this.getText().equalsIgnoreCase(arg0);
    }

    public void getChars(int arg0, int arg1, char[] arg2, int arg3) {
        this.getText().getChars(arg0, arg1, arg2, arg3);
    }

    public int indexOf(int arg0) {
        return this.getText().indexOf(arg0);
    }

    public int indexOf(int arg0, int arg1) {
        return this.getText().indexOf(arg0, arg1);
    }

    public int indexOf(String arg0) {
        return this.getText().indexOf(arg0);
    }

    public int indexOf(String arg0, int arg1) {
        return this.getText().indexOf(arg0, arg1);
    }

    public String intern() {
        return this.getText().intern();
    }

    public int lastIndexOf(int arg0) {
        return this.getText().lastIndexOf(arg0);
    }

    public int lastIndexOf(int arg0, int arg1) {
        return this.getText().lastIndexOf(arg0, arg1);
    }

    public int lastIndexOf(String arg0) {
        return this.getText().lastIndexOf(arg0);
    }

    public int lastIndexOf(String arg0, int arg1) {
        return this.getText().lastIndexOf(arg0, arg1);
    }

    @Override
    public int length() {
        return this.getText().length();
    }

    public boolean matches(String arg0) {
        return this.getText().matches(arg0);
    }

    public boolean regionMatches(boolean arg0, int arg1, String arg2, int arg3, int arg4) {
        return this.getText().regionMatches(arg0, arg1, arg2, arg3, arg4);
    }

    public boolean regionMatches(int arg0, String arg1, int arg2, int arg3) {
        return this.getText().regionMatches(arg0, arg1, arg2, arg3);
    }

    public String replace(char arg0, char arg1) {
        return this.getText().replace(arg0, arg1);
    }

    public String replaceAll(String arg0, String arg1) {
        return this.getText().replaceAll(arg0, arg1);
    }

    public String replaceFirst(String arg0, String arg1) {
        return this.getText().replaceFirst(arg0, arg1);
    }

    public String[] split(String arg0) {
        return this.getText().split(arg0);
    }

    public String[] split(String arg0, int arg1) {
        return this.getText().split(arg0, arg1);
    }

    public boolean startsWith(String arg0) {
        return this.getText().startsWith(arg0);
    }

    public boolean startsWith(String arg0, int arg1) {
        return this.getText().startsWith(arg0, arg1);
    }

    @Override
    public CharSequence subSequence(int arg0, int arg1) {
        return this.getText().subSequence(arg0, arg1);
    }

    public String substring(int arg0) {
        return this.getText().substring(arg0);
    }

    public String substring(int arg0, int arg1) {
        return this.getText().substring(arg0, arg1);
    }

    public String substringFrom(int position) {
        return this.substring(position);
    }

    public String substringTo(int position) {
        return this.substring(0, position);
    }

    public String substringWithoutLast(int characterCount) {
        return this.substringTo(this.getText().length() - characterCount);
    }

    private String getText() {
        return this.text;
    }

    public char[] toCharArray() {
        return this.getText().toCharArray();
    }

    public String toLowerCase() {
        return this.getText().toLowerCase();
    }

    public static String toLowerCase(String given) {
        if (null == given) {
            return null;
        }
        return given.toLowerCase();
    }

    public String toLowerCase(Locale arg0) {
        return this.getText().toLowerCase(arg0);
    }

    @Override
    public String toString() {
        return this.getText();
    }

    public String toUpperCase() {
        return this.getText().toUpperCase();
    }

    public String toUpperCase(Locale arg0) {
        return this.getText().toUpperCase(arg0);
    }

    public String trim() {
        return this.getText().trim();
    }

    public static boolean hasContent(String text) {
        return Text.hasContent(new StringStringProvider(text){

            @Override
            public String provideString() {
                return this.getString();
            }
        });
    }

    public static boolean hasContent(Text text) {
        return Text.hasContent(new TextStringProvider(text){

            @Override
            public String provideString() {
                return this.getText().toString();
            }
        });
    }

    public static boolean hasVisibleContent(String text) {
        return Text.hasContent(new StringStringProvider(text){

            @Override
            public String provideString() {
                return this.getString().trim();
            }
        });
    }

    public static boolean hasVisibleContent(Text text) {
        return Text.hasContent(new TextStringProvider(text){

            @Override
            public String provideString() {
                return this.getText().trim();
            }
        });
    }

    private static boolean hasContent(IStringProvider provider) {
        return !provider.isStringNull() && provider.provideString().length() > 0;
    }

    public Text reverse() {
        return Text.reverse(this);
    }

    public static Text reverse(Text text) {
        if (text == null) {
            return null;
        }
        return new Text(Text.reverse(text.toString()));
    }

    public static String reverse(String text) {
        if (text == null) {
            return null;
        }
        return new StringBuilder(text).reverse().toString();
    }

    public static String trimTrailing(String text, String remove) {
        if (null == remove) {
            throw new IllegalArgumentException("Cannot remove null string.");
        }
        if (remove.isEmpty()) {
            return text;
        }
        String result = text;
        while (result.endsWith(remove)) {
            result = result.substring(0, result.length() - remove.length());
        }
        return result;
    }

    public static String[] toStringArray(Object[] objects) {
        String[] result = new String[objects.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = String.valueOf(objects[i]);
        }
        return result;
    }

    public static String blanks(int countBlanks) {
        return Text.of(countBlanks, " ");
    }

    public static String dash(int surroundingBlanks) {
        String blankString = Text.blanks(surroundingBlanks);
        return new StringBuffer().append(blankString).append(dash).append(blankString).toString();
    }

    public static String newLine() {
        return System.getProperty("line.separator");
    }

    public static String of(int count, String characters) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(characters);
        }
        return result.toString();
    }

    public static String emptyIfNull(String text) {
        if (null == text) {
            return empty;
        }
        return text;
    }

    public String elipse(String elipsis, int maxLength, String elipseAfterThis) {
        if (this.containsNull() || maxLength >= this.length()) {
            return this.text;
        }
        int maxLengthOfOriginalText = maxLength - elipsis.length();
        String newText = this.text.substring(0, maxLengthOfOriginalText);
        int elipseAfter = newText.lastIndexOf(elipseAfterThis) + elipseAfterThis.length();
        if (0 > elipseAfter) {
            return newText + elipsis;
        }
        newText = newText.substring(0, elipseAfter);
        return newText + elipsis;
    }

    public static String itemize(String text) {
        return bullet + " " + text;
    }

    public static TextModification modify(String text) {
        return new TextModification(text);
    }

    public static String restrictTo(int maximumLength, String text) {
        if (null == text || text.length() <= maximumLength) {
            return text;
        }
        return text.substring(0, maximumLength) + "...";
    }

    private static interface IStringProvider {
        public boolean isStringNull();

        public String provideString();
    }

    private static abstract class StringStringProvider
    implements IStringProvider {
        private final String string;

        public StringStringProvider(String string) {
            this.string = string;
        }

        protected String getString() {
            return this.string;
        }

        @Override
        public final boolean isStringNull() {
            return this.getString() == null;
        }
    }

    private static abstract class TextStringProvider
    implements IStringProvider {
        private final Text text;

        public TextStringProvider(Text text) {
            this.text = text;
        }

        protected Text getText() {
            return this.text;
        }

        @Override
        public final boolean isStringNull() {
            return this.getText() == null || this.getText().containsNull();
        }
    }
}

