/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text;

import java.awt.Color;

public class HTMLText {
    private final String formattedText;

    public HTMLText(String text) {
        this.formattedText = text;
    }

    public static HTMLText text(String text) {
        return new HTMLText(text);
    }

    public static HTMLText bold(String text) {
        return new HTMLText(text.toString()).bold();
    }

    public static HTMLText italic(String text) {
        return new HTMLText(text.toString()).italic();
    }

    public static HTMLText underline(String text) {
        return new HTMLText(text.toString()).underline();
    }

    public static HTMLText color(String text, Color color) {
        return new HTMLText(text.toString()).color(color);
    }

    public HTMLText andText(String text) {
        return new HTMLText(this.formattedText + text);
    }

    public HTMLText br() {
        return new HTMLText(this.formattedText + "<br/>");
    }

    public HTMLText bold() {
        return new HTMLText("<b>" + this.formattedText + "</b>");
    }

    public HTMLText andBold(String text) {
        return new HTMLText(this.formattedText + "<b>" + text + "</b>");
    }

    public HTMLText italic() {
        return new HTMLText("<i>" + this.formattedText + "</i>");
    }

    public HTMLText andItalic(String text) {
        return new HTMLText(this.formattedText + "<i>" + text + "</i>");
    }

    public HTMLText underline() {
        return new HTMLText("<u>" + this.formattedText + "</u>");
    }

    public HTMLText andUnderline(String text) {
        return new HTMLText(this.formattedText + "<u>" + text + "</u>");
    }

    public HTMLText color(Color color) {
        String rgbString = this.getRGBStringFrom(color);
        return new HTMLText("<font color=\"#" + rgbString + "\">" + this.formattedText + "</font>");
    }

    public HTMLText andColor(String text, Color color) {
        String rgbString = this.getRGBStringFrom(color);
        return new HTMLText(this.formattedText + "<font color=\"#" + rgbString + "\">" + text + "</font>");
    }

    public HTMLText prepend(String text) {
        return new HTMLText(text + this.formattedText);
    }

    public HTMLText append(String text) {
        return new HTMLText(this.formattedText + text);
    }

    public HTMLText inHTMLTag() {
        return new HTMLText("<html>" + this.formattedText + "</html>");
    }

    public String build() {
        return this.formattedText;
    }

    public String buildHTML() {
        return this.inHTMLTag().build();
    }

    protected String getRGBStringFrom(Color color) {
        String r = this.getStringForColorComponent(color.getRed());
        String g = this.getStringForColorComponent(color.getGreen());
        String b = this.getStringForColorComponent(color.getBlue());
        return r + g + b;
    }

    protected String getStringForColorComponent(int colorComponent) {
        if (15 < colorComponent) {
            return Integer.toHexString(colorComponent);
        }
        return "0" + Integer.toHexString(colorComponent);
    }
}

