/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.test;

import java.util.ArrayList;
import java.util.List;

public class Benchmark {
    private final String denotation;
    private final List<BenchmarkTask> taskList;

    public Benchmark(BenchmarkTask ... tasks) {
        this("", tasks);
    }

    public Benchmark(String denotation, BenchmarkTask ... tasks) {
        this.denotation = denotation;
        this.taskList = new ArrayList<BenchmarkTask>();
        this.addTask(tasks);
    }

    public String getDenotation() {
        return this.denotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTask(BenchmarkTask ... tasks) {
        List<BenchmarkTask> list = this.taskList;
        synchronized (list) {
            for (BenchmarkTask task : tasks) {
                this.taskList.add(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() {
        List<BenchmarkTask> list = this.taskList;
        synchronized (list) {
            System.out.println("Performing benchmark: " + this.getDenotation());
            for (BenchmarkTask benchmarkTask : this.taskList) {
                this.performTask(benchmarkTask);
            }
        }
    }

    private void performTask(BenchmarkTask task) {
        System.out.print("  Benchmarking: " + task.getDenotation() + " (" + task.getRounds() + " rounds) --> ");
        long rounds = task.getRounds();
        task.setUp();
        long start = System.currentTimeMillis();
        task.begin();
        for (long i = 0L; i < rounds; ++i) {
            task.perform();
        }
        task.end();
        long end = System.currentTimeMillis();
        task.tearDown();
        System.out.println(end - start + "ms");
    }

    protected static abstract class BenchmarkTask {
        private final String taskDenotation;
        private final long rounds;

        public BenchmarkTask(long rounds) {
            this(rounds, "");
        }

        public BenchmarkTask(long rounds, String denotation) {
            this.rounds = rounds;
            this.taskDenotation = denotation;
        }

        public final String getDenotation() {
            return this.taskDenotation;
        }

        public final long getRounds() {
            return this.rounds;
        }

        public void setUp() {
        }

        public void begin() {
        }

        public abstract void perform();

        public void end() {
        }

        public void tearDown() {
        }
    }
}

