/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.system.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class Megabyte {
    private static final int CONVERSION_FACTOR_BYTE = 0x100000;
    public static final Megabyte AS_MUCH_AS_POSSIBLE = new Megabyte(2047);
    private static final DecimalFormat DEFAULT_FORMAT = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final String UNIT_STRING = "MB";
    private final long bytes;

    public Megabyte(double value) {
        this((long)(value * 1048576.0));
    }

    public Megabyte(int value) {
        this((long)value * 0x100000L);
    }

    private Megabyte(long bytes) {
        this.bytes = bytes;
    }

    public double getValue() {
        return (double)this.bytes / 1048576.0;
    }

    public long inBytes() {
        return this.bytes;
    }

    public static Megabyte fromBytes(long bytes) {
        return new Megabyte(bytes);
    }

    public static Megabyte fromString(String representation) {
        double unitFactor = 1.0;
        if (representation.endsWith("GB")) {
            unitFactor = 1000.0;
        }
        String parseable = representation.replace(UNIT_STRING, "").replace("GB", "");
        return new Megabyte(unitFactor * Double.parseDouble(parseable));
    }

    public boolean isLessThan(Megabyte other) {
        return this.inBytes() < other.inBytes();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(DEFAULT_FORMAT.format(this.getValue()));
        result.append(" ");
        result.append(UNIT_STRING);
        return result.toString();
    }
}

