/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.system.nativelib;

import com.schneide.base.system.Base;
import com.schneide.base.system.nativelib.LoaderException;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;

public final class NativeLibraryLoader {
    private NativeLibraryLoader() {
    }

    public static void loadLibrary(String libraryName) throws LoaderException {
        try {
            String libraryFilename = System.mapLibraryName(libraryName);
            URL libraryURL = ClassLoader.getSystemClassLoader().getResource(libraryFilename);
            if (null == libraryURL) {
                throw new LoaderException("Cannot find " + libraryFilename + " in classpath.");
            }
            File libraryFile = new File(libraryURL.toURI());
            Base.getLogger(NativeLibraryLoader.class).debug("Loading native library " + libraryName + " from path " + libraryFile.getAbsolutePath());
            System.load(libraryFile.getAbsolutePath());
        }
        catch (URISyntaxException e) {
            throw new LoaderException(e.getMessage());
        }
    }
}

