/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.system;

import com.schneide.base.i18n.implementation.GenericSingleInstanceTextualContentFactory;
import com.schneide.base.i18n.model.TextualContent;
import com.schneide.base.i18n.model.TextualContentFactory;
import com.schneide.base.logging.Logger;
import com.schneide.base.logging.LoggerFactory;
import com.schneide.base.logging.implementation.console.ConsoleLoggerFactory;

public final class Base {
    private static final String DEFAULT_LOGGER_IDENTIFICATION = "generic";
    private static final String NULL_LOGGER_IDENTIFICATION = "null";
    private static LoggerFactory currentLoggerFactory;
    private static TextualContentFactory currentTextContentFactory;

    private Base() {
    }

    public static Logger getDefaultLogger() {
        return Base.getLogger(DEFAULT_LOGGER_IDENTIFICATION);
    }

    public static Logger getLogger(Object instance) {
        if (instance == null) {
            return Base.getNullLogger();
        }
        return Base.getLogger(instance.getClass());
    }

    public static Logger getLogger(Class<?> objectClass) {
        if (objectClass == null) {
            return Base.getNullLogger();
        }
        return Base.getLogger(objectClass.getName());
    }

    public static Logger getLogger(String identification) {
        if (identification == null) {
            return Base.getNullLogger();
        }
        return Base.getLoggerFactory().getLogger(identification);
    }

    private static Logger getNullLogger() {
        return Base.getLogger(NULL_LOGGER_IDENTIFICATION);
    }

    private static LoggerFactory getLoggerFactory() {
        if (currentLoggerFactory == null) {
            currentLoggerFactory = new ConsoleLoggerFactory();
        }
        return currentLoggerFactory;
    }

    public static void setCurrentLoggerFactory(LoggerFactory loggerFactory) {
        currentLoggerFactory = loggerFactory;
    }

    public static void logOnConsole(String text) {
        System.out.println(text);
    }

    public static TextualContent getTextContent() {
        if (null == currentTextContentFactory) {
            Base.setCurrentTextContent(new NullTextualContent());
        }
        return currentTextContentFactory.getTextualContent("");
    }

    public static void setCurrentTextContent(TextualContent content) {
        Base.setCurrentTextContentFactory(new GenericSingleInstanceTextualContentFactory(content));
    }

    public static void setCurrentTextContentFactory(TextualContentFactory textContentFactory) {
        currentTextContentFactory = textContentFactory;
    }

    private static class NullTextualContent
    implements TextualContent {
        @Override
        public String getText(String key) {
            return key;
        }

        @Override
        public boolean hasTextFor(String key) {
            return true;
        }

        @Override
        public String getParametrizedText(String key, Object ... parameters) {
            return this.getText(key);
        }

        @Override
        public void reload() {
        }

        @Override
        public void clearCache() {
        }
    }
}

