/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.random;

import com.schneide.base.random.CharacterCategory;
import java.util.Random;

public class RandomnessGenerator {
    private static final RandomnessGenerator DEFAULT_GENERATOR = new RandomnessGenerator();
    private Random random;

    public RandomnessGenerator() {
        this(new Random());
    }

    public RandomnessGenerator(long seed) {
        this(new Random(seed));
    }

    public RandomnessGenerator(Random random) {
        this.random = random;
    }

    public static RandomnessGenerator getInstance() {
        return DEFAULT_GENERATOR;
    }

    public void setRandom(Random newRandom) {
        this.random = newRandom;
    }

    public Random getRandom() {
        return this.random;
    }

    public String getRandomStringOf(String[] array) {
        return (String)this.getRandomEntryOf(array);
    }

    public Object getRandomEntryOf(Object[] array) {
        return array[this.random.nextInt(array.length)];
    }

    public <T> T getGenericRandomEntryOf(T[] array) {
        return (T)this.getRandomEntryOf(array);
    }

    protected Character getRandomCharacterOf(Character[] array) {
        return (Character)this.getRandomEntryOf(array);
    }

    public String getRandomReadableString(CharacterCategory characters, int length) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            result.append(this.getRandomCharacterOf(characters.getCharacters()));
        }
        return result.toString();
    }

    public String getRandomReadableString(int length) {
        return this.getRandomReadableString(CharacterCategory.ALPHABETIC_CHARACTERS_AND_SPACE, length);
    }

    public int getRandomInteger(int maximalValue) {
        return this.getRandomInteger(0, maximalValue);
    }

    public int getRandomInteger(int minimalValue, int maximalValue) {
        return this.random.nextInt(maximalValue - minimalValue) + minimalValue;
    }

    public boolean isMaybeTrue(double factor) {
        return this.random.nextDouble() < factor;
    }

    public boolean isMaybeTrue() {
        return this.random.nextBoolean();
    }
}

