/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.random;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CharacterCategory {
    public static final CharacterCategory PUNCTUATION_MARKS = new CharacterCategory(new char[]{'.', ',', ':', ';', '!', '?', '\"', '\'', '-'});
    public static final CharacterCategory LOWERCASE_CHARACTERS = new CharacterCategory(new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'});
    public static final CharacterCategory UPPERCASE_CHARACTERS = new CharacterCategory(new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'});
    public static final CharacterCategory WHITESPACES = new CharacterCategory(new char[]{' ', '\t', '\n'});
    public static final CharacterCategory NUMBERS = new CharacterCategory(new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'});
    public static final CharacterCategory ALPHABETIC_CHARACTERS = new CharacterCategory(new CharacterCategory[]{LOWERCASE_CHARACTERS, UPPERCASE_CHARACTERS, NUMBERS});
    public static final CharacterCategory ALPHABETIC_CHARACTERS_AND_SPACE = new CharacterCategory(new CharacterCategory[]{ALPHABETIC_CHARACTERS}, new char[]{' '});
    public static final CharacterCategory SYMBOLS = new CharacterCategory(new char[]{'\u00a7', '$', '%', '&', '/', '(', ')', '=', '+', '*', '#', '<', '>', '|', '_', '~', '[', ']', '{', '}', '\\', '^'});
    public static final CharacterCategory FULL_SET = new CharacterCategory(new CharacterCategory[]{PUNCTUATION_MARKS, LOWERCASE_CHARACTERS, UPPERCASE_CHARACTERS, WHITESPACES, NUMBERS, SYMBOLS});
    private final List<Character> characters = new ArrayList<Character>();

    public CharacterCategory() {
        this(new Character[0]);
    }

    public CharacterCategory(CharacterCategory[] categories) {
        this(categories[0].getCharacters());
        for (int i = 1; i < categories.length; ++i) {
            this.addCharacters(categories[i].getCharacters());
        }
    }

    public CharacterCategory(CharacterCategory[] categories, char[] chars) {
        this(categories);
        this.addCharacters(chars);
    }

    public CharacterCategory(CharacterCategory[] categories, Character[] characters) {
        this(categories);
        this.addCharacters(characters);
    }

    public CharacterCategory(char[] chars) {
        this(CharacterCategory.getCharacterArrayOutOf(chars));
    }

    public CharacterCategory(Character[] characters) {
        Collections.addAll(this.characters, characters);
    }

    private static Character[] getCharacterArrayOutOf(char[] chars) {
        Character[] result = new Character[chars.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Character.valueOf(chars[i]);
        }
        return result;
    }

    public synchronized void addCharacter(char character) {
        this.addCharacter(character);
    }

    public synchronized void addCharacter(Character character) {
        this.addCharacters(new Character[]{character});
    }

    public synchronized void addCharacters(char[] chars) {
        this.addCharacters(CharacterCategory.getCharacterArrayOutOf(chars));
    }

    public synchronized void addCharacters(Character[] addedCharacters) {
        Collections.addAll(this.characters, addedCharacters);
    }

    public Character[] getCharacters() {
        return this.characters.toArray(new Character[this.characters.size()]);
    }

    public int getSize() {
        return this.characters.size();
    }
}

