/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.userLevel;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import com.schneide.base.properties.applicationLevel.StringProperty;
import java.util.Optional;
import java.util.function.Consumer;

public class ConfiguredString {
    private final Iterable<PropertyReferenceType> locations;
    private final Consumer<ConfigurationPart> preparation;
    private Optional<String> usingFallback;

    public ConfiguredString(PropertyReferenceType location, Consumer<ConfigurationPart> preparation) {
        this(new SingleElementIterable<PropertyReferenceType>(location), preparation);
    }

    public ConfiguredString(Iterable<PropertyReferenceType> locations, Consumer<ConfigurationPart> preparation) {
        this.locations = locations;
        this.preparation = preparation;
        this.usingFallback = Optional.empty();
    }

    public ConfiguredString withFallback(String fallback) {
        this.usingFallback = Optional.of(fallback);
        return this;
    }

    public String in(ConfigurationPart configuration) {
        this.preparation.accept(configuration);
        for (PropertyReferenceType each : this.locations) {
            StringProperty maybeProperty = StringProperty.buildConfigured(configuration, each, this.defaultValue());
            if (!maybeProperty.hasValue()) continue;
            return maybeProperty.getValue();
        }
        return this.defaultValue();
    }

    public Optional<String> maybeIn(ConfigurationPart configuration) {
        return Optional.ofNullable(this.in(configuration));
    }

    private String defaultValue() {
        return this.usingFallback.orElse(null);
    }
}

