/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.userLevel;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.IntegerProperty;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import java.util.Optional;
import java.util.function.Consumer;

public class ConfiguredInt {
    private final Iterable<PropertyReferenceType> locations;
    private final Consumer<ConfigurationPart> preparation;
    private Optional<Integer> usingFallback;

    public ConfiguredInt(PropertyReferenceType location, Consumer<ConfigurationPart> preparation) {
        this(new SingleElementIterable<PropertyReferenceType>(location), preparation);
    }

    public ConfiguredInt(Iterable<PropertyReferenceType> locations, Consumer<ConfigurationPart> preparation) {
        this.locations = locations;
        this.preparation = preparation;
        this.usingFallback = Optional.empty();
    }

    public ConfiguredInt withFallback(int fallback) {
        this.usingFallback = Optional.of(fallback);
        return this;
    }

    public Integer in(ConfigurationPart configuration) {
        this.preparation.accept(configuration);
        for (PropertyReferenceType each : this.locations) {
            IntegerProperty maybeProperty = IntegerProperty.buildConfigured(configuration, each, this.defaultValue());
            if (!maybeProperty.hasValue()) continue;
            return maybeProperty.getValue();
        }
        return this.defaultValue();
    }

    public Optional<Integer> maybeIn(ConfigurationPart configuration) {
        return Optional.ofNullable(this.in(configuration));
    }

    private Integer defaultValue() {
        return this.usingFallback.orElse(null);
    }
}

