/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.userLevel;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.BooleanProperty;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import java.util.Optional;
import java.util.function.Consumer;

public class ConfiguredBoolean {
    private final Iterable<PropertyReferenceType> locations;
    private final Consumer<ConfigurationPart> preparation;
    private Optional<Boolean> usingFallback;

    public ConfiguredBoolean(PropertyReferenceType location, Consumer<ConfigurationPart> preparation) {
        this(new SingleElementIterable<PropertyReferenceType>(location), preparation);
    }

    public ConfiguredBoolean(Iterable<PropertyReferenceType> locations, Consumer<ConfigurationPart> preparation) {
        this.locations = locations;
        this.preparation = preparation;
        this.usingFallback = Optional.empty();
    }

    public ConfiguredBoolean withFallback(boolean fallback) {
        this.usingFallback = Optional.of(fallback);
        return this;
    }

    public Boolean in(ConfigurationPart configuration) {
        this.preparation.accept(configuration);
        for (PropertyReferenceType each : this.locations) {
            BooleanProperty maybeProperty = BooleanProperty.buildConfigured(configuration, each, this.defaultValue());
            if (!maybeProperty.hasValue()) continue;
            return maybeProperty.getValue();
        }
        return this.defaultValue();
    }

    public Optional<Boolean> maybeIn(ConfigurationPart configuration) {
        return Optional.ofNullable(this.in(configuration));
    }

    private Boolean defaultValue() {
        return this.usingFallback.orElse(null);
    }
}

