/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.performance;

import java.util.function.Supplier;

public class PropertyCache<T>
implements Supplier<T> {
    private final Object cacheLock = new Object();
    private final long milliseconds;
    private final Supplier<T> loading;
    private T cached;
    private long lastLoaded;

    public PropertyCache(long milliseconds, Supplier<T> loading) {
        this.milliseconds = milliseconds;
        this.loading = loading;
        this.lastLoaded = 0L;
        this.cached = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object object = this.cacheLock;
        synchronized (object) {
            long now = this.now();
            if (this.needsReload(now)) {
                this.cached = this.loading.get();
                this.lastLoaded = now;
            }
            return this.cached;
        }
    }

    private boolean needsReload(long now) {
        return this.lastLoaded + this.milliseconds < now;
    }

    protected long now() {
        return System.currentTimeMillis();
    }
}

