/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.fileLevel;

import com.schneide.base.properties.fileLevel.ActiveElement;
import com.schneide.base.properties.fileLevel.PropertyEntry;
import com.schneide.base.properties.fileLevel.PropertyFileElement;
import com.schneide.base.properties.fileLevel.PropertyFileElementHolder;
import com.schneide.base.text.StringUtil;
import com.schneide.base.text.TextBuffer;
import com.schneide.base.text.parsing.LineParser;
import com.schneide.base.text.transformation.Disbrace;
import com.schneide.base.text.transformation.Embrace;
import java.text.ParseException;
import java.util.ArrayList;

public class PropertySection
extends ActiveElement {
    private final PropertyFileElementHolder sectionHolder;
    private String type = "";
    private String identifier = "";

    public static PropertySection forParts(String type, String identifier) {
        return new PropertySection(Embrace.withSquareBrackets(type + " \"" + identifier + "\""));
    }

    public PropertySection(String line) {
        super(line);
        this.setTypeAndIdentifierFrom(line);
        this.sectionHolder = new PropertyFileElementHolder();
    }

    private void setTypeAndIdentifierFrom(String line) {
        if (StringUtil.isEmptyOrNull(line)) {
            return;
        }
        String data = line.trim();
        data = Disbrace.fromSquareBrackets(line);
        try {
            String[] datas = new LineParser().splitArguments(data);
            this.type = datas[0];
            if (datas.length > 1) {
                this.identifier = datas[1];
            }
        }
        catch (ParseException e) {
            this.getLogger().error("Error parsing a property section.", e);
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void addElement(PropertyFileElement element) {
        this.sectionHolder.addElement(element);
    }

    public Iterable<PropertyFileElement> getElements() {
        return this.sectionHolder.getElements();
    }

    public <T extends PropertyFileElement> Iterable<T> getElementsOf(Class<T> wantedType) {
        ArrayList<PropertyFileElement> result = new ArrayList<PropertyFileElement>();
        for (PropertyFileElement each : this.getElements()) {
            if (!wantedType.isInstance(each)) continue;
            result.add((PropertyFileElement)wantedType.cast(each));
        }
        return result;
    }

    @Override
    public String getRepresentation() {
        TextBuffer result = new TextBuffer();
        result.addln(super.getRepresentation());
        result.append(this.sectionHolder.toString());
        result.setLength(result.length() - 1);
        return result.toString();
    }

    public Iterable<PropertyEntry> getPropertyEntries() {
        ArrayList<PropertyEntry> resultList = new ArrayList<PropertyEntry>();
        for (PropertyFileElement element : this.getElements()) {
            if (!(element instanceof PropertyEntry)) continue;
            resultList.add((PropertyEntry)element);
        }
        return resultList;
    }

    public String getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean leadingWhitespaceIsAssociated() {
        return true;
    }
}

