/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.fileLevel;

import com.schneide.base.properties.fileLevel.ActiveElement;
import com.schneide.base.text.parsing.StringChunker;

public class PropertyEntry
extends ActiveElement {
    private static final String separator = "=";
    private String key;
    private String value;

    public PropertyEntry(String key, String value) {
        this(PropertyEntry.getRepresentation(key, value));
    }

    public PropertyEntry(String line) {
        super(line);
        this.parseEntry(line);
    }

    private void parseEntry(String line) {
        StringChunker chunker = new StringChunker(line, separator);
        chunker.setCanReturnNull(false);
        this.key = chunker.getNextChunk().trim();
        this.value = chunker.getNextChunk().trim();
    }

    @Override
    public boolean isDeleted() {
        return this.value == null;
    }

    private static String getRepresentation(String key, String value) {
        StringBuffer result = new StringBuffer();
        result.append(key);
        result.append(separator);
        result.append(value);
        return result.toString();
    }

    @Override
    public String getRepresentation() {
        return PropertyEntry.getRepresentation(this.getKey(), this.getValue());
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void delete() {
        this.setValue(null);
    }
}

