/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.fileLevel;

import com.schneide.base.io.virtual.VirtualFile;
import java.util.function.Supplier;

public class DirtyFlag {
    private final Object lock = new Object();
    private final Supplier<Long> lastExternalModification;
    private boolean isDirty;
    private long lastModified;

    public static DirtyFlag of(VirtualFile file) {
        return new DirtyFlag(file::getLastModified);
    }

    public DirtyFlag(Supplier<Long> lastExternalModification) {
        this.lastExternalModification = lastExternalModification;
        this.isDirty = true;
        this.lastModified = lastExternalModification.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.lastModified = this.lastExternalModification.get();
            this.isDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportModification() {
        Object object = this.lock;
        synchronized (object) {
            this.isDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDirty) {
                return true;
            }
            if (this.lastExternalModification.get() != this.lastModified) {
                this.isDirty = true;
                return true;
            }
            return this.isDirty;
        }
    }
}

