/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.applicationLevel;

import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.InterpretedProperty;
import com.schneide.base.properties.applicationLevel.InterpretedSingleProperty;
import com.schneide.base.properties.applicationLevel.PropertyReference;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;

public class StringProperty
extends InterpretedSingleProperty {
    private String value;

    public static StringProperty named(String key) {
        return StringProperty.buildUnbound(PropertyReference.forKey(key));
    }

    private static void setDefaultValue(StringProperty property, String defaultValue) {
        if (InterpretedProperty.hasDefaultValue(defaultValue)) {
            property.value = defaultValue;
        }
    }

    public static StringProperty buildUnbound(PropertyReferenceType reference) {
        return StringProperty.buildUnbound(reference, null);
    }

    public static StringProperty buildUnbound(PropertyReferenceType reference, String defaultValue) {
        return new StringProperty(reference, defaultValue);
    }

    protected StringProperty(PropertyReferenceType reference, String defaultValue) {
        super(reference, InterpretedProperty.hasDefaultValue(defaultValue));
        StringProperty.setDefaultValue(this, defaultValue);
    }

    public static StringProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference) {
        return StringProperty.buildConfigured(configuration, reference, null);
    }

    public static StringProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference, String defaultValue) {
        return new StringProperty(configuration, reference, defaultValue);
    }

    protected StringProperty(ConfigurationPart part, PropertyReferenceType reference, String defaultValue) {
        super(part, reference, InterpretedProperty.hasDefaultValue(defaultValue));
        if (!this.isBound()) {
            StringProperty.setDefaultValue(this, defaultValue);
        }
    }

    @Override
    protected void convertToValue(String stringValue) {
        this.value = stringValue;
    }

    @Override
    protected String convertValueToString() {
        return this.getValue();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.notifyChange();
    }

    @Override
    public Object getGenericValue() {
        return this.getValue();
    }
}

