/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.applicationLevel;

import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.InterpretedProperty;
import com.schneide.base.properties.applicationLevel.InterpretedSingleProperty;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;

public class LongProperty
extends InterpretedSingleProperty {
    private long value;

    private static void setDefaultValue(LongProperty property, Long defaultValue) {
        if (InterpretedProperty.hasDefaultValue(defaultValue)) {
            property.value = defaultValue;
        }
    }

    public static LongProperty buildUnbound(PropertyReferenceType reference) {
        return LongProperty.buildUnbound(reference, null);
    }

    public static LongProperty buildUnbound(PropertyReferenceType reference, Long defaultValue) {
        return new LongProperty(reference, defaultValue);
    }

    protected LongProperty(PropertyReferenceType reference, Long defaultValue) {
        super(reference, InterpretedProperty.hasDefaultValue(defaultValue));
        LongProperty.setDefaultValue(this, defaultValue);
    }

    public static LongProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference) {
        return LongProperty.buildConfigured(configuration, reference, null);
    }

    public static LongProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference, Long defaultValue) {
        return new LongProperty(configuration, reference, defaultValue);
    }

    protected LongProperty(ConfigurationPart configuration, PropertyReferenceType reference, Long defaultValue) {
        super(configuration, reference, InterpretedProperty.hasDefaultValue(defaultValue));
        if (!this.isBound()) {
            LongProperty.setDefaultValue(this, defaultValue);
        }
    }

    @Override
    protected void convertToValue(String stringValue) {
        try {
            this.value = Long.parseLong(stringValue);
        }
        catch (NumberFormatException e) {
            this.getLogger().error("Could not parse the input to a long: " + stringValue, e);
        }
    }

    @Override
    protected String convertValueToString() {
        return Long.toString(this.value);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
        this.notifyChange();
    }

    @Override
    public Object getGenericValue() {
        return this.getValue();
    }
}

