/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.applicationLevel;

import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.Configuration;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.Property;
import com.schneide.base.properties.PropertyValueListener;
import com.schneide.base.properties.applicationLevel.PropertyChangeListener;
import com.schneide.base.properties.applicationLevel.PropertyMetadata;
import com.schneide.base.properties.applicationLevel.PropertyReference;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import java.util.ArrayList;
import java.util.List;

public abstract class InterpretedProperty
extends LoggedObject
implements PropertyValueListener {
    private final String section;
    private final String key;
    private final boolean hasDefaultValue;
    private Property boundProperty;
    private Configuration boundConfiguration;
    private PropertyMetadata metadata;
    private final List<PropertyChangeListener> propertyChangeListenerList;

    public InterpretedProperty(PropertyReferenceType reference) {
        this(reference, false);
    }

    public InterpretedProperty(PropertyReferenceType reference, boolean hasDefaultValue) {
        this.section = reference.getSection();
        this.key = reference.getKey();
        this.hasDefaultValue = hasDefaultValue;
        this.metadata = new PropertyMetadata();
        this.boundProperty = null;
        this.boundConfiguration = null;
        this.propertyChangeListenerList = new ArrayList<PropertyChangeListener>();
    }

    public InterpretedProperty(Property property) {
        this(PropertyReference.forKey(property.getKey()), true);
    }

    public InterpretedProperty(ConfigurationPart configuration, PropertyReferenceType reference, boolean hasDefaultValue) {
        this(configuration.resolveRelativeReference(reference), hasDefaultValue);
        this.bindTo(configuration.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            List<PropertyChangeListener> list = this.propertyChangeListenerList;
            synchronized (list) {
                this.propertyChangeListenerList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            List<PropertyChangeListener> list = this.propertyChangeListenerList;
            synchronized (list) {
                this.propertyChangeListenerList.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChanged() {
        List<PropertyChangeListener> list = this.propertyChangeListenerList;
        synchronized (list) {
            for (PropertyChangeListener propertyChangeListener : this.propertyChangeListenerList) {
                propertyChangeListener.propertyChanged(this);
            }
        }
    }

    public void bindTo(Configuration configuration) {
        this.boundConfiguration = configuration;
        if (this.boundConfiguration.hasProperty(this.section, this.key)) {
            this.boundProperty = this.hasDefaultValue ? this.getDefaultValuedProperty(configuration, this.section, this.key) : configuration.getProperty(this.section, this.key);
            this.propertyValueChanged(this.boundProperty);
        }
    }

    public void enableRealtimeUpdate() {
        this.getBoundProperty().addPropertyValueListener(this);
    }

    public void disableRealtimeUpdate() {
        this.getBoundProperty().removePropertyValueListener(this);
    }

    protected abstract Property getDefaultValuedProperty(Configuration var1, String var2, String var3);

    protected abstract void notifyChange();

    @Override
    public abstract void propertyValueChanged(Property var1);

    protected boolean isBound() {
        return this.boundProperty != null;
    }

    protected Property getBoundProperty() {
        return this.boundProperty;
    }

    public void commit() {
        if (this.boundConfiguration != null) {
            this.boundConfiguration.commit();
        }
    }

    public String getKey() {
        return this.key;
    }

    public boolean hasValue() {
        return this.isBound() && this.getBoundProperty().hasValue();
    }

    public abstract Object getGenericValue();

    public void setMetadata(PropertyMetadata metadata) {
        this.metadata = metadata;
    }

    public PropertyMetadata getMetadata() {
        return this.metadata;
    }

    protected static boolean hasDefaultValue(Object defaultValue) {
        return defaultValue != null;
    }
}

