/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.applicationLevel;

import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.BooleanSyntax;
import com.schneide.base.properties.applicationLevel.InterpretedProperty;
import com.schneide.base.properties.applicationLevel.InterpretedSingleProperty;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;

public class BooleanProperty
extends InterpretedSingleProperty {
    private boolean value;
    private BooleanSyntax valueSyntax;

    private static void setDefaultValue(BooleanProperty property, Boolean defaultValue) {
        if (InterpretedProperty.hasDefaultValue(defaultValue)) {
            property.value = defaultValue;
        }
    }

    public static BooleanProperty buildUnbound(PropertyReferenceType reference) {
        return BooleanProperty.buildUnbound(reference, null);
    }

    public static BooleanProperty buildUnbound(PropertyReferenceType reference, boolean defaultValue) {
        return BooleanProperty.buildUnbound(reference, defaultValue);
    }

    public static BooleanProperty buildUnbound(PropertyReferenceType reference, Boolean defaultValue) {
        return new BooleanProperty(reference, defaultValue);
    }

    protected BooleanProperty(PropertyReferenceType reference, Boolean defaultValue) {
        super(reference, InterpretedProperty.hasDefaultValue(defaultValue));
        BooleanProperty.setDefaultValue(this, defaultValue);
    }

    public static BooleanProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference) {
        return BooleanProperty.buildConfigured(configuration, reference, null);
    }

    public static BooleanProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference, Boolean defaultValue) {
        return new BooleanProperty(configuration, reference, defaultValue);
    }

    protected BooleanProperty(ConfigurationPart configuration, PropertyReferenceType reference, Boolean defaultValue) {
        super(configuration, reference, InterpretedProperty.hasDefaultValue(defaultValue));
        if (!this.isBound()) {
            BooleanProperty.setDefaultValue(this, defaultValue);
        }
    }

    @Override
    protected void convertToValue(String stringValue) {
        for (BooleanSyntax element : BooleanSyntax.DEFAULT) {
            if (element.isPositiveValue(stringValue)) {
                this.setValue(true, element, false);
                break;
            }
            if (!element.isNegativeValue(stringValue)) continue;
            this.setValue(false, element, false);
            break;
        }
    }

    public static boolean parse(String text) {
        for (BooleanSyntax each : BooleanSyntax.DEFAULT) {
            if (each.isPositiveValue(text)) {
                return true;
            }
            if (!each.isNegativeValue(text)) continue;
            return false;
        }
        return false;
    }

    private void setValue(boolean newValue, BooleanSyntax syntax, boolean isNotificationEnabled) {
        this.value = newValue;
        this.valueSyntax = syntax;
        if (isNotificationEnabled) {
            this.notifyChange();
        }
    }

    @Override
    protected String convertValueToString() {
        if (this.hasValueSyntax()) {
            return this.getValueSyntax().getValueOf(this.getValue());
        }
        return Boolean.toString(this.getValue());
    }

    private boolean hasValueSyntax() {
        return this.getValueSyntax() != null;
    }

    private BooleanSyntax getValueSyntax() {
        return this.valueSyntax;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public Object getGenericValue() {
        return this.getValue();
    }

    public void setValue(boolean value) {
        this.value = value;
        this.notifyChange();
    }

    public void setValue(Boolean value) {
        this.setValue(value);
    }

    public void setValue(Boolean newValue, BooleanSyntax syntax) {
        this.setValue(newValue, syntax);
    }
}

