/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties;

import com.schneide.base.properties.ConfigurationSection;
import com.schneide.base.properties.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;

public class SectionHolder {
    private final Object reloadLock;
    private final Map<String, ConfigurationSection> sectionMap;
    private final List<ConfigurationSection> sectionList;

    public SectionHolder(Object reloadLock) {
        this.reloadLock = reloadLock;
        this.sectionMap = new HashMap<String, ConfigurationSection>();
        this.sectionList = new ArrayList<ConfigurationSection>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addSection(ConfigurationSection section) {
        Object object = this.reloadLock;
        synchronized (object) {
            this.sectionMap.put(section.getIdentifier(), section);
            this.sectionList.add(section);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mergeSection(ConfigurationSection section) {
        Object object = this.reloadLock;
        synchronized (object) {
            Property[] properties;
            if (!this.hasSection(section.getIdentifier())) {
                this.addSection(section);
                return;
            }
            ConfigurationSection present = this.getSection(section.getIdentifier());
            for (Property each : properties = section.getProperties()) {
                present.addProperty(each.getKey(), each.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasSection(String identifier) {
        Object object = this.reloadLock;
        synchronized (object) {
            return this.sectionMap.containsKey(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Optional<ConfigurationSection> section(String identifier) {
        Object object = this.reloadLock;
        synchronized (object) {
            if (this.hasSection(identifier)) {
                return Optional.ofNullable(this.sectionMap.get(identifier));
            }
            return Optional.empty();
        }
    }

    public synchronized ConfigurationSection getSection(String identifier) throws NoSuchElementException {
        return this.section(identifier).orElseThrow(() -> new NoSuchElementException("Sektion '" + identifier + "' nicht gefunden."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Iterable<ConfigurationSection> getSections() {
        Object object = this.reloadLock;
        synchronized (object) {
            return new ArrayList<ConfigurationSection>(this.sectionList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeSection(ConfigurationSection section) {
        Object object = this.reloadLock;
        synchronized (object) {
            this.sectionList.remove(section);
            this.sectionMap.remove(section.getIdentifier());
        }
    }
}

