/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties;

import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.PropertyValueListener;
import com.schneide.base.properties.fileLevel.PropertyEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class Property
extends LoggedObject {
    private final String key;
    private final List<PropertyEntry> entryList;
    private final List<PropertyValueListener> propertyValueListenerList;

    public Property(String key) {
        this.key = key;
        this.entryList = new ArrayList<PropertyEntry>();
        this.propertyValueListenerList = new ArrayList<PropertyValueListener>();
    }

    public Property(PropertyEntry firstEntry) {
        this(firstEntry.getKey());
        this.addEntry(firstEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyValueListener(PropertyValueListener listener) {
        if (null != listener) {
            List<PropertyValueListener> list = this.propertyValueListenerList;
            synchronized (list) {
                this.propertyValueListenerList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyValueListener(PropertyValueListener listener) {
        if (listener != null) {
            List<PropertyValueListener> list = this.propertyValueListenerList;
            synchronized (list) {
                this.propertyValueListenerList.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyValueChanged() {
        List<PropertyValueListener> list = this.propertyValueListenerList;
        synchronized (list) {
            for (PropertyValueListener listener : this.propertyValueListenerList) {
                listener.propertyValueChanged(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(PropertyEntry entry) {
        if (entry != null) {
            List<PropertyEntry> list = this.entryList;
            synchronized (list) {
                this.entryList.add(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(PropertyEntry entry) {
        if (entry != null) {
            List<PropertyEntry> list = this.entryList;
            synchronized (list) {
                this.entryList.remove(entry);
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValues() {
        List<PropertyEntry> list = this.entryList;
        synchronized (list) {
            String[] result = new String[this.entryList.size()];
            int index = 0;
            for (PropertyEntry propertyEntry : this.entryList) {
                result[index] = propertyEntry.getValue();
                ++index;
            }
            return result;
        }
    }

    public Optional<String> value() {
        return Optional.ofNullable(this.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue() {
        List<PropertyEntry> list = this.entryList;
        synchronized (list) {
            int position = this.entryList.size() - 1;
            if (position < 0) {
                return null;
            }
            PropertyEntry entry = this.entryList.get(position);
            return entry.getValue();
        }
    }

    public boolean hasMultipleEntries() {
        return this.getSize() > 1;
    }

    public boolean hasValue() {
        return this.getSize() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        List<PropertyEntry> list = this.entryList;
        synchronized (list) {
            return this.entryList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String value) {
        List<PropertyEntry> list = this.entryList;
        synchronized (list) {
            for (PropertyEntry element : this.entryList) {
                element.setValue(value);
            }
        }
        this.notifyValueChanged();
    }

    public void deleteAll() {
        this.deleteEntries(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeleted() {
        List<PropertyEntry> list = this.entryList;
        synchronized (list) {
            for (PropertyEntry element : this.entryList) {
                if (element.isDeleted()) continue;
                return false;
            }
            return true;
        }
    }

    public void removeDuplicates() {
        this.deleteEntries(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEntries(boolean exceptLast) {
        List<PropertyEntry> list = this.entryList;
        synchronized (list) {
            Iterator<PropertyEntry> iter = this.entryList.iterator();
            while (iter.hasNext()) {
                PropertyEntry element = iter.next();
                if (!iter.hasNext() && exceptLast) continue;
                element.delete();
                iter.remove();
            }
        }
        this.notifyValueChanged();
    }

    public String toString() {
        if (this.isDeleted()) {
            return "";
        }
        return this.getKey() + "=" + this.getValue();
    }
}

