/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties;

import com.schneide.base.properties.Configuration;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.Property;
import com.schneide.base.properties.applicationLevel.PropertyReference;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import com.schneide.base.properties.fileLevel.PropertyEntry;
import com.schneide.base.properties.fileLevel.PropertyFile;
import com.schneide.base.properties.fileLevel.PropertySection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;

public class ConfigurationSection
implements ConfigurationPart {
    private final PropertyFile origin;
    private final Configuration configuration;
    private final PropertySection section;
    private final Map<String, Property> propertyMap;
    private final List<Property> propertyList;

    public ConfigurationSection(PropertyFile origin, PropertySection section, Configuration configuration) {
        this.origin = origin;
        this.section = section;
        this.configuration = configuration;
        PropertyCaches caches = this.buildPropertyCaches(section);
        this.propertyMap = caches.mapped();
        this.propertyList = caches.listed();
    }

    public ConfigurationSection(Configuration configuration, String type, String identifier, PropertyFile origin) {
        this(origin, PropertySection.forParts(type, identifier), configuration);
    }

    public PropertySection getPropertySection() {
        return this.section;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getPartIdentifier() {
        return this.getIdentifier();
    }

    private PropertyCaches buildPropertyCaches(PropertySection forSection) {
        HashMap<String, Property> map = new HashMap<String, Property>();
        ArrayList<Property> list = new ArrayList<Property>();
        for (PropertyEntry element : forSection.getPropertyEntries()) {
            if (!map.containsKey(element.getKey())) {
                Property neu = new Property(element.getKey());
                map.put(neu.getKey(), neu);
                list.add(neu);
            }
            Property property = (Property)map.get(element.getKey());
            property.addEntry(element);
        }
        return new PropertyCaches(map, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasProperty(String key) {
        Map<String, Property> map = this.propertyMap;
        synchronized (map) {
            return this.propertyMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Property> propertyFor(String key) {
        Map<String, Property> map = this.propertyMap;
        synchronized (map) {
            Predicate<Property> deleted = Property::isDeleted;
            return Optional.ofNullable(this.propertyMap.get(key)).filter(deleted.negate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Property getProperty(String key) throws NoSuchElementException {
        Property result = null;
        Map<String, Property> map = this.propertyMap;
        synchronized (map) {
            result = this.propertyMap.get(key);
        }
        if (result != null) {
            return result;
        }
        throw new NoSuchElementException("Keine Property '" + key + "' gefunden.");
    }

    public String getIdentifier() {
        return this.section.getIdentifier();
    }

    public String getType() {
        return this.section.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property[] getProperties() {
        Map<String, Property> map = this.propertyMap;
        synchronized (map) {
            return this.propertyList.toArray(new Property[this.propertyList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Property> properties() {
        Map<String, Property> map = this.propertyMap;
        synchronized (map) {
            return this.propertyList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String key, String value) {
        PropertyEntry newEntry = new PropertyEntry(key, value);
        this.section.addElement(newEntry);
        Property newProperty = new Property(newEntry);
        Map<String, Property> map = this.propertyMap;
        synchronized (map) {
            if (this.propertyMap.containsKey(newProperty.getKey())) {
                this.propertyMap.get(newProperty.getKey()).addEntry(newEntry);
            } else {
                this.propertyList.add(newProperty);
            }
            this.propertyMap.put(newProperty.getKey(), newProperty);
        }
        if (this.isDefaultSection()) {
            this.origin.addPropertyElement(key, value);
        }
    }

    @Override
    public PropertyReferenceType resolveRelativeReference(PropertyReferenceType reference) {
        return new PropertyReference(this.getIdentifier(), reference.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProperties() {
        Map<String, Property> map = this.propertyMap;
        synchronized (map) {
            return !this.propertyMap.isEmpty();
        }
    }

    public boolean isDefaultSection() {
        return "".equals(this.section.getType());
    }

    public void setProperty(String key, String value) {
        this.setPropertyValue(key, value);
    }

    public void setPropertyValue(String key, String value) {
        if (!this.hasProperty(key)) {
            this.addProperty(key, value);
            return;
        }
        this.getProperty(key).setValue(value);
    }

    public String toString() {
        return this.section.getRepresentation();
    }

    private record PropertyCaches(Map<String, Property> mapped, List<Property> listed) {
    }
}

