/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.number;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;

public final class NumberPersistence {
    private NumberPersistence() {
    }

    public static String format(Number number) {
        return NumberPersistence.getIsoDecimalFormatter().format(number);
    }

    public static BigDecimal parse(String value) throws ParseException {
        return (BigDecimal)NumberPersistence.getIsoDecimalFormatter().parse(value);
    }

    private static DecimalFormat getIsoDecimalFormatter() {
        DecimalFormat result = new DecimalFormat("0.#########################");
        result.setDecimalFormatSymbols(new IsoFormatSymbols());
        result.setGroupingUsed(false);
        result.setParseBigDecimal(true);
        return result;
    }

    public static final class IsoFormatSymbols
    extends DecimalFormatSymbols {
        private static final long serialVersionUID = 1L;

        @Override
        public char getDecimalSeparator() {
            return ',';
        }

        @Override
        public String getExponentSeparator() {
            return "E";
        }
    }
}

