/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.network.socket;

import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.network.socket.SocketClientConfiguration;
import com.schneide.base.threading.SchneideThread;
import com.schneide.base.threading.executor.DoInBackground;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SocketClient<INPUT extends AutoCloseable>
extends LoggedObject
implements LifeCycle {
    private final String bezeichnung;
    private final SocketClientConfiguration einstellungen;
    private final InputCreation<INPUT> creation;
    private final TransmissionCycle<INPUT> cycle;
    private volatile boolean shouldRun;

    public SocketClient(String bezeichnung, SocketClientConfiguration einstellungen, InputCreation<INPUT> creation, TransmissionCycle<INPUT> cycle) {
        this.creation = creation;
        this.cycle = cycle;
        this.shouldRun = false;
        this.bezeichnung = bezeichnung;
        this.einstellungen = einstellungen;
    }

    @Override
    public void start() {
        this.shouldRun = true;
        DoInBackground.now(this.bezeichnung, () -> {
            while (this.shouldRun) {
                this.connectAndWorkWith(this::transmitUsing);
                if (!this.shouldRun) continue;
                long verz\u00f6gerung = this.einstellungen.wiederverbindungsverz\u00f6gerung();
                this.getLogger().warn("Verbindung von " + this.bezeichnung + " abgebrochen, verbinde in " + verz\u00f6gerung + " ms erneut.");
                SchneideThread.performDelay(verz\u00f6gerung);
            }
            this.getLogger().debug(this.bezeichnung + " gestoppt.");
        });
        this.getLogger().debug(this.bezeichnung + " gestartet.");
    }

    private void connectAndWorkWith(BiConsumer<InputStream, OutputStream> transmission) {
        try (Socket socket = new Socket(this.einstellungen.hostAddress(), this.einstellungen.port());
             InputStream input = this.tapIn(socket);
             OutputStream output = this.tapOut(socket);){
            this.getLogger().info("Verbindung von " + this.bezeichnung + " mit " + socket.getInetAddress().toString() + " erfolgreich aufgebaut.");
            transmission.accept(input, output);
        }
        catch (IOException e) {
            this.getLogger().error("Kann die Verbindung zu " + this.bezeichnung + " nicht herstellen.", e);
        }
    }

    private void transmitUsing(InputStream input, OutputStream output) {
        try {
            INPUT usedInput = this.creation.createFrom(input);
            Consumer<String> logging = this.logging();
            while (this.shouldRun) {
                this.cycle.cycleWith(usedInput, output, logging, () -> this.shouldRun);
            }
        }
        catch (IOException e) {
            this.getLogger().error("\u00dcbertragungsfehler von " + this.bezeichnung + ", schlie\u00dfe aktuelle Verbindung.", e);
        }
    }

    @Override
    public void stop() {
        this.shouldRun = false;
    }

    private Consumer<String> logging() {
        return text -> {
            if (!this.einstellungen.loggingAktiviert()) {
                return;
            }
            this.getLogger().debug(this.bezeichnung + ": " + text);
        };
    }

    private InputStream tapIn(Socket socket) throws IOException {
        InputStream input = socket.getInputStream();
        return input;
    }

    private OutputStream tapOut(Socket socket) throws IOException {
        OutputStream output = socket.getOutputStream();
        return output;
    }

    public static interface InputCreation<INPUT extends AutoCloseable> {
        public INPUT createFrom(InputStream var1) throws IOException;
    }

    public static interface TransmissionCycle<INPUT extends AutoCloseable> {
        public void cycleWith(INPUT var1, OutputStream var2, Consumer<String> var3, Supplier<Boolean> var4) throws IOException;
    }
}

