/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.network;

import com.schneide.base.logging.LoggedObject;
import java.io.IOException;
import java.net.ServerSocket;

public final class AcquireSocket
extends LoggedObject {
    private final int port;

    private AcquireSocket(int port) {
        this.port = port;
    }

    public ServerSocket orUseArbitraryFreePort() {
        try {
            return new ServerSocket(this.port);
        }
        catch (IOException e) {
            this.getLogger().error("Webserver port " + this.port + " is not available. Using arbitrary free port.", e);
            try {
                ServerSocket result = new ServerSocket(0);
                this.getLogger().warn("Ramses center webserver now listens on port " + result.getLocalPort());
                return result;
            }
            catch (IOException e1) {
                this.getLogger().fatal("Could not acquire any free port on the system. Aborting.", e1);
                return null;
            }
        }
    }

    public static AcquireSocket any() {
        return AcquireSocket.at(0);
    }

    public static AcquireSocket at(int port) {
        return new AcquireSocket(port);
    }
}

