/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.maths;

import com.schneide.base.maths.AbstractIterativeDoubleCalculator;
import java.util.Optional;

public class IterativeDoubleMinimumCalculator
extends AbstractIterativeDoubleCalculator {
    private final double resetValue;
    private double minimumValue;

    public IterativeDoubleMinimumCalculator() {
        this(Double.MAX_VALUE);
    }

    public IterativeDoubleMinimumCalculator(double resetValue) {
        this.resetValue = resetValue;
        this.minimumValue = resetValue;
    }

    @Override
    protected void internalAddValue(double value) {
        this.minimumValue = Math.min(this.minimumValue, value);
    }

    @Override
    protected void internalReset() {
        this.minimumValue = this.resetValue;
    }

    public double getMinimumValue() {
        return this.performSynchronized(() -> this.minimumValue);
    }

    public Optional<Double> minimumValueIfCalculated() {
        if (!this.hasValues()) {
            return Optional.empty();
        }
        return Optional.of(this.getMinimumValue());
    }
}

