/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.maths;

import com.schneide.base.maths.AbstractIterativeDoubleCalculator;
import com.schneide.base.maths.IterativeDoubleMeanCalculator;

public class IterativeDoubleDeviationCalculator
extends AbstractIterativeDoubleCalculator {
    private final double initialValue;
    private double variance;
    private IterativeDoubleMeanCalculator meanCalculator;
    private double deviation;

    public IterativeDoubleDeviationCalculator() {
        this.initialValue = 0.0;
        this.internalReset();
    }

    @Override
    protected void internalAddValue(double value) {
        double oldMeanValue = this.getMeanValue();
        this.meanCalculator.addValue(value);
        if (!Double.isNaN(oldMeanValue)) {
            this.variance *= (double)(this.getValueCount() - 1) / (double)this.getValueCount();
            this.variance += 1.0 / (double)this.getValueCount() * value * value;
            this.variance += (double)(this.getValueCount() - 1) / (double)this.getValueCount() * oldMeanValue * oldMeanValue;
            this.variance -= this.getMeanValue() * this.getMeanValue();
        }
        this.deviation = Math.sqrt(this.variance);
    }

    @Override
    protected final void internalReset() {
        this.variance = this.initialValue;
        this.meanCalculator = new IterativeDoubleMeanCalculator();
    }

    public double getMeanValue() {
        return this.performSynchronized(() -> this.meanCalculator.getMeanValue());
    }

    public double getDeviation() {
        return this.performSynchronized(() -> this.deviation);
    }
}

