/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.loader.xml;

import com.schneide.base.loader.FileWrapper;
import com.schneide.base.loader.xml.XmlTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XMLFileIOHandler {
    private final FileWrapper source;
    private Document document;

    public XMLFileIOHandler(FileWrapper source) {
        this.source = source;
        this.document = null;
    }

    public final boolean hasContent() {
        return this.document != null;
    }

    public final Document getDocument() {
        return this.document;
    }

    public final void setDocument(Document document) {
        this.document = document;
    }

    public final Element getRootElement() {
        return this.document.getRootElement();
    }

    public final void setRootElement(Element root) {
        this.document.setRootElement(root);
    }

    protected final void loadDocument() throws IOException, JDOMException {
        this.loadDocument(this.getSource());
    }

    protected final void loadDocument(File file) throws IOException, JDOMException {
        this.loadDocument(new FileWrapper(file));
    }

    private void loadDocument(FileWrapper file) throws IOException, JDOMException {
        this.loadDocument(file.getInputStream());
    }

    private final void loadDocument(InputStream stream) throws IOException, JDOMException {
        this.document = XmlTools.readDocument(stream);
        stream.close();
    }

    protected final void writeDocument() throws IOException {
        this.writeDocument(this.getSource(), this.getDocument());
    }

    protected final void writeDocument(Element rootNode) throws IOException {
        this.writeDocument(this.getSource(), rootNode);
    }

    protected final void writeDocument(Document theDocument) throws IOException {
        this.writeDocument(this.getSource(), theDocument);
    }

    protected final void writeDocument(File file) throws IOException {
        this.writeDocument(file, this.getDocument());
    }

    protected final void writeDocument(File file, Element rootNode) throws IOException {
        this.setRootElement(rootNode);
        this.writeDocument(file);
    }

    protected final void writeDocument(File file, Document theDocument) throws IOException {
        this.writeDocument(new FileWrapper(file), theDocument);
    }

    private final void writeDocument(FileWrapper wrapper) throws IOException {
        this.writeDocument(wrapper, this.getDocument());
    }

    private final void writeDocument(FileWrapper wrapper, Element element) throws IOException {
        this.setRootElement(element);
        this.writeDocument(wrapper);
    }

    private final void writeDocument(FileWrapper wrapper, Document theDocument) throws IOException {
        if (wrapper == null) {
            throw new IOException("Zieldatei nicht angegeben (null)");
        }
        if (theDocument == null) {
            throw new IOException("Dokument nicht angegeben (null)");
        }
        this.document = theDocument;
        XMLFileIOHandler.writeToDisk(wrapper, theDocument);
    }

    public static final void writeTo(File file, Document document) throws IOException {
        XMLFileIOHandler.writeToDisk(new FileWrapper(file), document);
    }

    private static final void writeToDisk(FileWrapper wrapper, Document document) throws IOException {
        try (OutputStream out = wrapper.getOutputStream();){
            Format xmlFormat = Format.getPrettyFormat();
            xmlFormat.setEncoding("ISO-8859-1");
            XMLOutputter output = new XMLOutputter(xmlFormat);
            output.output(document, out);
        }
    }

    protected FileWrapper getSource() {
        return this.source;
    }
}

