/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.loader.xml;

import com.schneide.base.loader.AbstractModelHandler;
import com.schneide.base.loader.FileTopicalityHandler;
import com.schneide.base.loader.xml.XMLFileIOHandler;
import java.io.File;
import java.io.IOException;
import org.jdom2.Document;
import org.jdom2.JDOMException;

public abstract class AbstractXMLModelHandler
extends AbstractModelHandler {
    private final XMLFileIOHandler ioHandler;

    public AbstractXMLModelHandler(File file, boolean canSave) {
        this(new FileTopicalityHandler(file), canSave);
    }

    protected AbstractXMLModelHandler(FileTopicalityHandler topicalityHandler, boolean canSave) {
        this(topicalityHandler, new XMLFileIOHandler(topicalityHandler.getFileWrapper()), canSave);
    }

    protected AbstractXMLModelHandler(FileTopicalityHandler topicalityHandler, XMLFileIOHandler ioHandler, boolean canSave) {
        super(topicalityHandler, canSave);
        this.ioHandler = ioHandler;
    }

    protected final Document getXMLDocument() {
        return this.getXMLFileIO().getDocument();
    }

    private final XMLFileIOHandler getXMLFileIO() {
        return this.ioHandler;
    }

    @Override
    protected final Object loadModel() throws IOException {
        try {
            this.getXMLFileIO().loadDocument();
            return this.unmarshalModel(this.getXMLFileIO().getDocument());
        }
        catch (JDOMException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected final void saveModel(Object currentModel) throws IOException {
        this.getXMLFileIO().writeDocument(this.marshalModel(currentModel));
    }

    protected abstract Object unmarshalModel(Document var1);

    protected abstract Document marshalModel(Object var1);
}

