/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.loader;

import com.schneide.base.io.file.FileUtil;
import com.schneide.base.loader.ModelSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileWrapper
implements ModelSource {
    private final File file;

    public FileWrapper(File file) {
        this.checkForValidity(file);
        this.file = file;
    }

    private void checkForValidity(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument sollte nicht null sein.");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    private OutputStream getOutputStream(File targetFile) throws FileNotFoundException {
        File parentDirectory = targetFile.getParentFile();
        if (!parentDirectory.exists()) {
            FileUtil.ensureSuccessWithWarning("Error while creating dir", parentDirectory.mkdirs());
        }
        return new FileOutputStream(targetFile);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(this.file);
    }

    public boolean isFile() {
        return this.file != null;
    }

    @Override
    public long getLastModificationStamp() {
        return this.file.lastModified();
    }

    public File getFile() {
        return this.file;
    }
}

