/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.listener;

import com.schneide.base.listener.ListenerHandler;
import com.schneide.base.threading.ThreadMutex;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WeakReferencedListenerHandler<L>
extends ListenerHandler<L> {
    private final List<WeakReference<L>> listeners = new ArrayList<WeakReference<L>>();
    private final ThreadMutex listenerLock = new ThreadMutex();

    public WeakReferencedListenerHandler() {
        this("");
    }

    public WeakReferencedListenerHandler(String denotation) {
        super(denotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(L listener) {
        if (null == listener) {
            this.warnAboutNullParameters("register");
            return;
        }
        ThreadMutex threadMutex = this.listenerLock;
        synchronized (threadMutex) {
            this.listeners.add(new WeakReference<L>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(L listener) {
        if (null == listener) {
            this.warnAboutNullParameters("deregister");
            return;
        }
        ThreadMutex threadMutex = this.listenerLock;
        synchronized (threadMutex) {
            Iterator<WeakReference<L>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<L> reference = iterator.next();
                if (null == reference.get()) {
                    iterator.remove();
                    continue;
                }
                if (listener != reference.get()) continue;
                iterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Iterable<L> getCurrentListeners() {
        ThreadMutex threadMutex = this.listenerLock;
        synchronized (threadMutex) {
            ArrayList activeListeners = new ArrayList();
            Iterator<WeakReference<L>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<L> reference = iterator.next();
                if (null == reference.get()) {
                    iterator.remove();
                    continue;
                }
                activeListeners.add(reference.get());
            }
            return activeListeners;
        }
    }
}

