/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.listener;

import com.schneide.base.threading.Executable;

public abstract class NotificationJoinThread
extends Executable {
    private final Iterable<Executable> executables;

    public NotificationJoinThread(String denotation, Iterable<Executable> executables) {
        super("NotificationEndJoin for " + denotation);
        this.executables = executables;
    }

    @Override
    protected final void execute() throws Exception {
        this.startNotification();
        this.waitForNotificationCompletion();
        this.performAfterCompletionOn(this.executables);
    }

    protected final void startNotification() {
        for (Executable executable : this.executables) {
            executable.startExecution();
        }
    }

    protected abstract void performAfterCompletionOn(Iterable<Executable> var1);

    protected final void waitForNotificationCompletion() {
        for (Executable executable : this.executables) {
            try {
                executable.getThread().join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.getLogger().warn("Joined thread was interrupted.", e);
            }
        }
    }
}

